/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.plants;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BushLogBlock
extends Block {
    public static final BooleanProperty FOILAGED = BooleanProperty.create((String)"fully_foliaged");
    public static final BooleanProperty[] CDIRS = new BooleanProperty[]{BooleanProperty.create((String)"n"), BooleanProperty.create((String)"s"), BooleanProperty.create((String)"w"), BooleanProperty.create((String)"e")};
    static final VoxelShape shape = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    public BushLogBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        BlockState def = (BlockState)super.defaultBlockState().setValue((Property)FOILAGED, (Comparable)Boolean.valueOf(false));
        for (BooleanProperty i : CDIRS) {
            def = (BlockState)def.setValue((Property)i, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(def);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FOILAGED});
        for (BooleanProperty i : CDIRS) {
            builder.add(new Property[]{i});
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FOILAGED, (Comparable)Boolean.valueOf(false));
    }

    public static BlockState setFullShape(BlockState state) {
        for (BooleanProperty i : CDIRS) {
            state = (BlockState)state.setValue((Property)i, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.setValue((Property)FOILAGED, (Comparable)Boolean.valueOf(true));
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection.getStepY() != 0) {
            return pState;
        }
        pState = pNeighborState.is(BlockTags.LEAVES) ? (BlockState)pState.setValue((Property)CDIRS[pDirection.ordinal() - 2], (Comparable)Boolean.valueOf(true)) : (BlockState)pState.setValue((Property)CDIRS[pDirection.ordinal() - 2], (Comparable)Boolean.valueOf(false));
        for (BooleanProperty i : CDIRS) {
            if (((Boolean)pState.getValue((Property)i)).booleanValue()) continue;
            return (BlockState)pState.setValue((Property)FOILAGED, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)pState.setValue((Property)FOILAGED, (Comparable)Boolean.valueOf(true));
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }
}

