/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.pan;

import com.teammoeg.caupona.CPGui;
import com.teammoeg.caupona.blocks.pan.PanBlockEntity;
import com.teammoeg.caupona.container.CPBaseContainer;
import com.teammoeg.caupona.container.HidableSlot;
import com.teammoeg.caupona.container.OutputSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class PanContainer
extends CPBaseContainer<PanBlockEntity> {
    public PanContainer(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, (PanBlockEntity)inv.player.level().getBlockEntity(buffer.readBlockPos()));
    }

    public PanContainer(int id, final Inventory inv, final PanBlockEntity blockEntity) {
        super((MenuType)CPGui.PAN.get(), blockEntity, id, 12);
        for (int i = 0; i < 9; ++i) {
            this.addSlot((Slot)new HidableSlot((IItemHandler)blockEntity.inv, i, 62 + i % 3 * 18, 13 + i / 3 * 18, () -> blockEntity.processMax == 0));
        }
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.inv, 9, 147, 13));
        this.addSlot((Slot)new OutputSlot((IItemHandler)blockEntity.inv, 10, 136, 47));
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)blockEntity.inv, 11, 125, 13){

            public boolean mayPlace(ItemStack stack) {
                if (!inv.player.getAbilities().instabuild && blockEntity.isInfinite) {
                    return false;
                }
                return super.mayPlace(stack);
            }

            public boolean mayPickup(Player playerIn) {
                if (!inv.player.getAbilities().instabuild && blockEntity.isInfinite) {
                    return false;
                }
                return super.mayPickup(playerIn);
            }
        });
        super.addPlayerInventory(inv, 8, 84, 142);
    }

    @Override
    public boolean quickMoveIn(ItemStack slotStack) {
        return this.moveItemStackTo(slotStack, 9, 10, false) || this.moveItemStackTo(slotStack, 11, 12, false) || this.moveItemStackTo(slotStack, 0, 9, false);
    }
}

