/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.pan;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.blocks.foods.IFoodContainer;
import com.teammoeg.caupona.blocks.pan.GravyBoatBlock;
import com.teammoeg.caupona.blocks.pan.PanContainer;
import com.teammoeg.caupona.blocks.stove.IStove;
import com.teammoeg.caupona.components.SauteedFoodInfo;
import com.teammoeg.caupona.data.recipes.FoodValueRecipe;
import com.teammoeg.caupona.data.recipes.PanPendingContext;
import com.teammoeg.caupona.data.recipes.SauteedRecipe;
import com.teammoeg.caupona.data.recipes.SpiceRecipe;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.IInfinitable;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;

public class PanBlockEntity
extends CPBaseBlockEntity
implements MenuProvider,
IInfinitable,
IFoodContainer {
    public int process;
    public int processMax;
    public boolean working = false;
    public boolean operate = false;
    public boolean rsstate = false;
    boolean isInfinite = false;
    boolean removesNBT;
    public ItemStack preout = ItemStack.EMPTY;
    public ItemStack sout = ItemStack.EMPTY;
    public ItemStackHandler inv = new ItemStackHandler(this, 12){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < 9) {
                return SauteedRecipe.isCookable(stack);
            }
            if (slot == 9) {
                return stack.is(Items.BOWL);
            }
            if (slot == 11) {
                return SpiceRecipe.isValid(stack);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            if (slot < 9) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }
    };
    public IItemHandler bowl = new IItemHandler(){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot < 9 || slot == 10) {
                return stack;
            }
            return PanBlockEntity.this.inv.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 9 || slot == 11) {
                return ItemStack.EMPTY;
            }
            if (slot < 9 && PanBlockEntity.this.inv.isItemValid(slot, PanBlockEntity.this.inv.getStackInSlot(slot))) {
                return ItemStack.EMPTY;
            }
            ItemStack item = PanBlockEntity.this.inv.extractItem(slot, amount, simulate);
            if (slot == 10 && !item.isEmpty() && PanBlockEntity.this.sout.isEmpty()) {
                PanBlockEntity.this.syncData();
            }
            return item;
        }

        public int getSlots() {
            return PanBlockEntity.this.inv.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return PanBlockEntity.this.inv.getStackInSlot(slot);
        }

        public int getSlotLimit(int slot) {
            return PanBlockEntity.this.inv.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot < 9 || slot == 10) {
                return false;
            }
            return PanBlockEntity.this.inv.isItemValid(slot, stack);
        }
    };
    RangedWrapper ingredient = new RangedWrapper(this, (IItemHandlerModifiable)this.inv, 0, 10){

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }
    };

    public PanBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CPBlockEntityTypes.PAN.get(), pWorldPosition, pBlockState);
    }

    @Override
    public void handleMessage(short type, int data) {
        if (type == 0) {
            this.operate = true;
        }
        if (type == 1) {
            if (data == 1) {
                this.rsstate = false;
            } else if (data == 2) {
                this.rsstate = true;
            }
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider ra) {
        this.working = nbt.getBoolean("working");
        this.operate = nbt.getBoolean("operate");
        this.rsstate = nbt.getBoolean("rsstate");
        this.process = nbt.getInt("process");
        this.processMax = nbt.getInt("processMax");
        this.sout = nbt.contains("sout") ? ItemStack.parseOptional((HolderLookup.Provider)ra, (CompoundTag)nbt.getCompound("sout")) : ItemStack.EMPTY;
        this.inv.deserializeNBT(ra, nbt.getCompound("items"));
        if (!isClient) {
            this.isInfinite = nbt.getBoolean("inf");
            this.removesNBT = nbt.getBoolean("removeNbt");
        }
        this.preout = ItemStack.parseOptional((HolderLookup.Provider)ra, (CompoundTag)nbt.getCompound("result"));
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider ra) {
        nbt.putBoolean("working", this.working);
        nbt.putBoolean("operate", this.operate);
        nbt.putBoolean("rsstate", this.rsstate);
        nbt.putInt("process", this.process);
        nbt.putInt("processMax", this.processMax);
        nbt.put("sout", this.sout.saveOptional(ra));
        nbt.put("items", (Tag)this.inv.serializeNBT(ra));
        if (!isClient) {
            nbt.putBoolean("inf", this.isInfinite);
            nbt.putBoolean("removeNbt", this.removesNBT);
        }
        nbt.put("result", this.preout.saveOptional(ra));
    }

    private ItemStack tryAddSpice(ItemStack fs) {
        Object object;
        ItemStack ospi;
        ItemStack spi = ospi = this.inv.getStackInSlot(11);
        SpiceRecipe spice = SpiceRecipe.find(spi);
        if (this.getBlockState().is((Block)CPBlocks.LEAD_PAN.get()) && spice != null && spice.canReactLead) {
            spi = CPItems.getSapa();
            spice = SpiceRecipe.find(spi);
        }
        if (spice != null && SpiceRecipe.getMaxUse(ospi) >= fs.getCount() && (object = CPCapability.FOOD_INFO.getCapability(fs, null)) instanceof SauteedFoodInfo) {
            SauteedFoodInfo si = (SauteedFoodInfo)object;
            if (!this.isInfinite) {
                this.inv.setStackInSlot(11, SpiceRecipe.handle(ospi, fs.getCount()));
            }
            si.addSpice(spice.effect, spi);
        }
        return fs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tick() {
        if (this.level.isClientSide) return;
        this.working = false;
        if (this.processMax > 0) {
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.below());
            if (!(blockEntity instanceof IStove)) return;
            IStove stove = (IStove)blockEntity;
            int rh = stove.requestHeat();
            this.process += rh;
            if (rh > 0) {
                this.working = true;
                this.syncData();
            }
            if (this.process < this.processMax) return;
            this.process = 0;
            this.processMax = 0;
            this.doWork();
            this.setChanged();
            return;
        } else if (!this.sout.isEmpty()) {
            this.operate = false;
            if (!this.inv.getStackInSlot(10).isEmpty()) return;
            if (!this.isInfinite) {
                this.inv.setStackInSlot(10, this.tryAddSpice(this.sout.split(1)));
            } else {
                this.inv.setStackInSlot(10, this.tryAddSpice(this.sout.copyWithCount(1)));
            }
            this.setChanged();
            return;
        } else {
            this.prepareWork();
        }
    }

    private void prepareWork() {
        if (this.rsstate && !this.operate && this.level.hasNeighborSignal(this.worldPosition)) {
            this.operate = true;
        }
        if (this.operate) {
            IStove stove;
            this.operate = false;
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.below());
            if (!(blockEntity instanceof IStove) || !(stove = (IStove)blockEntity).canEmitHeat()) {
                return;
            }
            this.make();
        }
    }

    private void doWork() {
        this.removesNBT = false;
        this.sout = this.preout;
        this.preout = ItemStack.EMPTY;
    }

    private void make() {
        ItemStack is;
        int itms = 0;
        for (int i = 0; i < 9; ++i) {
            Direction[] is2 = this.inv.getStackInSlot(i);
            if (is2.isEmpty()) continue;
            if (SauteedRecipe.isCookable((ItemStack)is2)) {
                ++itms;
                continue;
            }
            return;
        }
        if (itms <= 0) {
            return;
        }
        BlockPos oilProvidingPos = null;
        for (Direction d : Utils.horizontals) {
            int oil;
            BlockPos bp = this.getBlockPos().relative(d);
            BlockState bs = this.getLevel().getBlockState(bp);
            if (!bs.is((Block)CPBlocks.GRAVY_BOAT.get()) || (oil = GravyBoatBlock.getOil(bs)) <= 0) continue;
            oilProvidingPos = bp;
            break;
        }
        if (oilProvidingPos == null) {
            return;
        }
        if (this.inv.getStackInSlot(9).isEmpty()) {
            return;
        }
        NonNullList interninv = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        block2: for (int i = 0; i < 9; ++i) {
            ItemStack is3 = this.inv.getStackInSlot(i);
            if (is3.isEmpty()) continue;
            for (int j = 0; j < 9; ++j) {
                ItemStack ois = (ItemStack)interninv.get(j);
                if (ois.isEmpty()) {
                    interninv.set(j, (Object)is3.copy());
                    continue block2;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)ois, (ItemStack)is3)) continue;
                ois.setCount(ois.getCount() + is3.getCount());
                continue block2;
            }
        }
        int tpt = 0;
        SauteedFoodInfo current = new SauteedFoodInfo();
        for (int i = 0; i < 9 && !(is = (ItemStack)interninv.get(i)).isEmpty(); ++i) {
            current.addItem(is);
            FoodValueRecipe fvr = FoodValueRecipe.recipes.get(is.getItem());
            if (fvr == null) continue;
            tpt += fvr.processtimes.getOrDefault(is.getItem(), 0).intValue();
        }
        interninv.clear();
        current.completeAll();
        PanPendingContext ctx = new PanPendingContext(current);
        float tcount = 0.0f;
        Item preout = Items.AIR;
        int processMax = 0;
        boolean removesNBT = false;
        for (RecipeHolder<SauteedRecipe> cr : SauteedRecipe.sorted) {
            if (!((SauteedRecipe)cr.value()).matches(ctx)) continue;
            processMax = Math.max(((SauteedRecipe)cr.value()).time, tpt);
            preout = ((SauteedRecipe)cr.value()).output;
            removesNBT = ((SauteedRecipe)cr.value()).removeNBT;
            tcount = ((SauteedRecipe)cr.value()).count;
            break;
        }
        if (preout == Items.AIR) {
            return;
        }
        if (tcount <= 0.0f) {
            tcount = 2.0f;
        }
        int cook = Mth.ceil((float)((float)itms / tcount));
        if (this.inv.getStackInSlot(9).getCount() < cook) {
            return;
        }
        GravyBoatBlock.drawOil(this.getLevel(), oilProvidingPos, 1);
        for (int i = 0; i < 9; ++i) {
            ItemStack is4 = this.inv.getStackInSlot(i);
            if (is4.isEmpty()) continue;
            this.inv.setStackInSlot(i, is4.getCraftingRemainingItem());
        }
        this.process = 0;
        this.processMax = 0;
        tpt = Math.max((Integer)CPConfig.SERVER.fryTimeBase.get(), tpt);
        current.setParts(cook);
        current.recalculateHAS();
        this.preout = new ItemStack((ItemLike)preout, cook);
        this.preout.set(CPCapability.SAUTEED_INFO, (Object)current);
        this.processMax = processMax;
        this.removesNBT = removesNBT;
        this.inv.getStackInSlot(9).shrink(cook);
        if (this.getBlockState().is((Block)CPBlocks.STONE_PAN.get())) {
            tpt *= 2;
        }
        processMax = tpt;
        this.syncData();
    }

    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new PanContainer(pContainerId, pInventory, this);
    }

    public Component getDisplayName() {
        return Utils.translate("container.caupona.pan.title");
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    @Override
    public boolean setInfinity() {
        this.isInfinite = !this.isInfinite;
        return this.isInfinite;
    }

    @Override
    public ItemStack getInternal(int num) {
        ItemStack result = this.inv.extractItem(10, 1, true);
        return result;
    }

    @Override
    public void setInternal(int num, ItemStack is) {
        this.inv.extractItem(10, 1, false);
        is = this.inv.insertItem(9, is, false);
        this.syncData();
        Utils.dropToWorld(this.getLevel(), is, this.getBlockPos());
    }

    @Override
    public int getSlots() {
        return 1;
    }

    @Override
    public boolean accepts(int num, ItemStack is) {
        return is.is(Items.BOWL);
    }

    @Override
    public Object getCapability(BlockCapability<?, Direction> type, Direction d) {
        if (type == Capabilities.ItemHandler.BLOCK) {
            if (d == Direction.UP) {
                return this.ingredient;
            }
            return this.bowl;
        }
        return null;
    }
}

