/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.pan;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.blocks.CPHorizontalEntityBlock;
import com.teammoeg.caupona.blocks.pan.PanBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PanBlock
extends CPHorizontalEntityBlock<PanBlockEntity> {
    static final VoxelShape bshape = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    static final VoxelShape sshape = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);

    public PanBlock(BlockBehaviour.Properties p_54120_) {
        super(CPBlockEntityTypes.PAN, p_54120_);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getBlock() == CPBlocks.STONE_PAN.get()) {
            return bshape;
        }
        return sshape;
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionResult p = super.useWithoutItem(state, worldIn, pos, player, hit);
        if (p.consumesAction()) {
            return p;
        }
        PanBlockEntity blockEntity = (PanBlockEntity)worldIn.getBlockEntity(pos);
        if (blockEntity != null && !worldIn.isClientSide) {
            ((ServerPlayer)player).openMenu((MenuProvider)blockEntity, blockEntity.getBlockPos());
        }
        return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof PanBlockEntity) {
            ItemStack is;
            PanBlockEntity pan = (PanBlockEntity)blockEntity;
            if (pan.processMax == 0) {
                for (int i = 0; i < 9; ++i) {
                    is = pan.inv.getStackInSlot(i);
                    if (is.isEmpty()) continue;
                    CPHorizontalEntityBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)is);
                }
            }
            for (int i = 9; i < 12; ++i) {
                is = pan.inv.getStackInSlot(i);
                if (is.isEmpty()) continue;
                CPHorizontalEntityBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)is);
            }
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof PanBlockEntity) {
            PanBlockEntity pan = (PanBlockEntity)blockEntity;
            if (pan.processMax == 0) {
                int ret = 1;
                if (!pan.sout.isEmpty() || !pan.inv.getStackInSlot(10).isEmpty()) {
                    return 15;
                }
                for (int i = 0; i < 9; ++i) {
                    ItemStack is = pan.getInv().getStackInSlot(i);
                    if (is.isEmpty()) continue;
                    ++ret;
                }
                return ret;
            }
        }
        return 0;
    }
}

