/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.pan;

import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.blocks.CPHorizontalBlock;
import com.teammoeg.caupona.util.CreativeTabItemHelper;
import com.teammoeg.caupona.util.ICreativeModeTabItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GravyBoatBlock
extends CPHorizontalBlock
implements ICreativeModeTabItem {
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"damage", (int)0, (int)5);
    static final VoxelShape shapeNS = Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)7.0, (double)12.0);
    static final VoxelShape shapeEW = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)13.0);

    public GravyBoatBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
        CODEC = GravyBoatBlock.simpleCodec(GravyBoatBlock::new);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Z) {
            return shapeNS;
        }
        return shapeEW;
    }

    public static int getOil(BlockState pState) {
        return 5 - (Integer)pState.getValue((Property)LEVEL);
    }

    public static boolean drawOil(Level pLevel, BlockPos pPos, int count) {
        BlockState pState = pLevel.getBlockState(pPos);
        int dmg = (Integer)pState.getValue((Property)LEVEL);
        if (dmg + count <= 5) {
            pState = (BlockState)pState.setValue((Property)LEVEL, (Comparable)Integer.valueOf(dmg + count));
            pLevel.setBlockAndUpdate(pPos, pState);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)LEVEL, (Comparable)Integer.valueOf(context.getItemInHand().getDamageValue()));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEVEL});
    }

    @Override
    public void fillItemCategory(CreativeTabItemHelper helper) {
        if (helper.isFoodTab()) {
            helper.accept((ItemLike)this);
            ItemStack is = new ItemStack((ItemLike)this);
            is.setDamageValue(is.getMaxDamage());
            helper.accept(is);
        }
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pBuilder) {
        List sep = super.getDrops(pState, pBuilder);
        for (ItemStack is : sep) {
            if (!is.is((Item)CPItems.gravy_boat.get())) continue;
            is.setDamageValue(((Integer)pState.getValue((Property)LEVEL)).intValue());
        }
        return sep;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack is = new ItemStack((ItemLike)CPItems.gravy_boat.get());
        is.setDamageValue(((Integer)state.getValue((Property)LEVEL)).intValue());
        return is;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return 15 - (Integer)pState.getValue((Property)LEVEL) * 3;
    }
}

