/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.hypocaust;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.blocks.hypocaust.BathHeatingBlockEntity;
import com.teammoeg.caupona.blocks.hypocaust.WolfStatueBlock;
import com.teammoeg.caupona.blocks.stove.IStove;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.LazyTickWorker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WolfStatueBlockEntity
extends CPBaseBlockEntity {
    boolean isVeryHot;
    private LazyTickWorker check;

    public WolfStatueBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CPBlockEntityTypes.WOLF_STATUE.get(), pWorldPosition, pBlockState);
        this.check = new LazyTickWorker((Integer)CPConfig.SERVER.wolfTick.get(), () -> {
            BlockPos bp = this.getBlockPos();
            BlockState bs = this.getBlockState();
            int bheat = (Integer)bs.getValue((Property)WolfStatueBlock.HEAT);
            for (int i = 0; i < 4; ++i) {
                bp = bp.below();
                BlockEntity patt0$temp = this.getLevel().getBlockEntity(bp);
                if (!(patt0$temp instanceof BathHeatingBlockEntity)) continue;
                BathHeatingBlockEntity bath = (BathHeatingBlockEntity)patt0$temp;
                int cheat = Math.min(bath.getHeat(), 2);
                if (cheat != bheat) {
                    this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)bs.setValue((Property)WolfStatueBlock.HEAT, (Comparable)Integer.valueOf(cheat)));
                }
                return true;
            }
            if (bheat != 0) {
                this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)bs.setValue((Property)WolfStatueBlock.HEAT, (Comparable)Integer.valueOf(0)));
            }
            return true;
        });
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        this.isVeryHot = nbt.getBoolean("very_hot");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        nbt.putBoolean("very_hot", this.isVeryHot);
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().below());
        if (blockEntity instanceof IStove) {
            IStove stove = (IStove)blockEntity;
            BlockState bs = this.getBlockState();
            int nh = stove.requestHeat();
            int bheat = (Integer)bs.getValue((Property)WolfStatueBlock.HEAT);
            boolean flag = false;
            bs = (BlockState)bs.setValue((Property)WolfStatueBlock.HEAT, (Comparable)Integer.valueOf(nh));
            if (bheat != nh) {
                flag = true;
            }
            if (!this.isVeryHot) {
                this.setChanged();
            }
            boolean bl = this.isVeryHot = nh > 0;
            if (this.isVeryHot && ((Boolean)bs.getValue((Property)WolfStatueBlock.WATERLOGGED)).booleanValue()) {
                bs = (BlockState)bs.setValue((Property)WolfStatueBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
                this.level.levelEvent(1501, this.worldPosition, 0);
                flag = true;
            }
            if (flag) {
                this.getLevel().setBlockAndUpdate(this.getBlockPos(), bs);
            }
            return;
        }
        this.isVeryHot = false;
        this.check.tick();
    }
}

