/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.hypocaust;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.blocks.CPHorizontalEntityBlock;
import com.teammoeg.caupona.blocks.hypocaust.WolfStatueBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WolfStatueBlock
extends CPHorizontalEntityBlock<WolfStatueBlockEntity>
implements SimpleWaterloggedBlock {
    public static final IntegerProperty HEAT = IntegerProperty.create((String)"heat", (int)0, (int)2);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    static final VoxelShape shapeNS = Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    static final VoxelShape shapeEW = Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);

    public WolfStatueBlock(BlockBehaviour.Properties blockProps) {
        super(CPBlockEntityTypes.WOLF_STATUE, blockProps);
        super.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HEAT, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Z) {
            return shapeNS;
        }
        return shapeEW;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HEAT}).add(new Property[]{WATERLOGGED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)HEAT, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.entityInside(pState, pLevel, pPos, pEntity);
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof WolfStatueBlockEntity) {
            WolfStatueBlockEntity wst = (WolfStatueBlockEntity)blockEntity;
            if (wst.isVeryHot) {
                pEntity.hurt(pLevel.damageSources().hotFloor(), (float)((Integer)pState.getValue((Property)HEAT)).intValue());
            }
        }
    }

    public void stepOn(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof WolfStatueBlockEntity) {
            WolfStatueBlockEntity wst = (WolfStatueBlockEntity)blockEntity;
            if (wst.isVeryHot) {
                pEntity.hurt(pLevel.damageSources().hotFloor(), (float)((Integer)pState.getValue((Property)HEAT)).intValue());
            }
        }
        super.stepOn(pLevel, pPos, pState, pEntity);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        int ret = (Integer)pState.getValue((Property)HEAT) * 3;
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof WolfStatueBlockEntity) {
            WolfStatueBlockEntity wst = (WolfStatueBlockEntity)blockEntity;
            if (wst.isVeryHot) {
                ret += 9;
            }
        }
        return ret;
    }
}

