/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.hypocaust;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.blocks.hypocaust.BathHeatingBlockEntity;
import com.teammoeg.caupona.blocks.stove.IStove;
import com.teammoeg.caupona.util.LazyTickWorker;
import com.teammoeg.caupona.util.Utils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FireboxBlockEntity
extends BathHeatingBlockEntity {
    LazyTickWorker process;
    int heat;
    private int r;

    public FireboxBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CPBlockEntityTypes.HYPOCAUST_FIREBOX.get(), pWorldPosition, pBlockState);
        this.r = (Integer)CPConfig.SERVER.bathRange.get();
        this.process = new LazyTickWorker(Mth.ceil((float)((float)((Integer)CPConfig.SERVER.bathPath.get()).intValue() / 2.0f)), () -> {
            Set<BlockPos> pss = this.getAll();
            for (BlockPos pos : pss) {
                BlockEntity patt0$temp = this.level.getBlockEntity(pos);
                if (!(patt0$temp instanceof BathHeatingBlockEntity)) continue;
                BathHeatingBlockEntity bath = (BathHeatingBlockEntity)patt0$temp;
                bath.setHeat(this.heat);
            }
            return true;
        });
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        super.readCustomNBT(nbt, isClient, registries);
        this.heat = nbt.getInt("heatSpeed");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        super.writeCustomNBT(nbt, isClient, registries);
        nbt.putInt("heatSpeed", this.heat);
    }

    private boolean dist(BlockPos crn, BlockPos orig) {
        return Mth.abs((int)(crn.getX() - orig.getX())) <= this.r && Mth.abs((int)(crn.getZ() - orig.getZ())) <= this.r;
    }

    public void findNext(Level l, BlockPos crn, BlockPos orig, Set<BlockPos> pos) {
        if (this.dist(crn, orig) && pos.add(crn)) {
            for (Direction dir : Utils.horizontals) {
                BlockPos act = crn.relative(dir);
                if (!l.isLoaded(act) || !l.getBlockState(act).is(CPTags.Blocks.HYPOCAUST_HEAT_CONDUCTOR)) continue;
                this.findNext(l, act, orig, pos);
            }
        }
    }

    public Set<BlockPos> getAll() {
        HashSet<BlockPos> poss = new HashSet<BlockPos>();
        this.findNext(this.getLevel(), this.getBlockPos(), this.getBlockPos(), poss);
        return poss;
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.below());
        if (blockEntity instanceof IStove) {
            IStove stove = (IStove)blockEntity;
            int nh = stove.requestHeat();
            if (this.heat != nh) {
                this.process.enqueue();
                this.heat = nh;
            }
        } else if (this.heat != 0) {
            this.process.enqueue();
            this.heat = 0;
        }
        this.process.tick();
        this.setChanged();
        super.tick();
    }

    @Override
    public int getHeat() {
        return Math.max(((BathHeatingBlockEntity)this).heat, this.heat);
    }
}

