/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.hypocaust;

import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.LazyTickWorker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BathHeatingBlockEntity
extends CPBaseBlockEntity {
    private double rate;
    private int val;
    protected LazyTickWorker process;
    protected int heat;
    private boolean water;

    public BathHeatingBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
        this.rate = (Double)CPConfig.SERVER.bathChance.get();
        this.val = (Integer)CPConfig.SERVER.bathExp.get();
        this.process = new LazyTickWorker((Integer)CPConfig.SERVER.bathPath.get(), () -> {
            if (this.heat != 0) {
                this.heat = 0;
                return true;
            }
            return false;
        });
        this.water = (Boolean)CPConfig.SERVER.strictWater.get() == false;
    }

    public int getHeat() {
        return this.heat;
    }

    public void setHeat(int val) {
        if (this.heat > val) {
            return;
        }
        this.process.rewind();
        if (this.heat != val) {
            this.heat = val;
            this.syncData();
        } else {
            this.setChanged();
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        this.heat = nbt.getInt("bathHeat");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        nbt.putInt("bathHeat", this.heat);
    }

    protected static boolean inRange(int pos, double d) {
        return d >= (double)pos && d < (double)(pos + 1);
    }

    protected static boolean inRange(double pos, double d, double dmax) {
        return d >= pos && d < pos + dmax;
    }

    protected boolean isInWater(Player p) {
        if (this.water) {
            return true;
        }
        if (p.isInWaterOrBubble()) {
            return true;
        }
        Entity e = p.getVehicle();
        while (e != null) {
            if (e.isInWaterOrBubble()) {
                return true;
            }
            e = p.getVehicle();
        }
        return false;
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        int heat = this.getHeat();
        if (this.val > 0 && heat > 0 && this.level.random.nextDouble() < this.rate && this.getLevel().getFluidState(this.getBlockPos().above()).is(FluidTags.WATER)) {
            int posX = this.getBlockPos().getX();
            int posY = this.getBlockPos().getY();
            int posZ = this.getBlockPos().getZ();
            int addExp = this.val * heat;
            for (Player p : this.getLevel().players()) {
                if (!BathHeatingBlockEntity.inRange(posX, p.getX()) || !BathHeatingBlockEntity.inRange(posZ, p.getZ()) || !BathHeatingBlockEntity.inRange(posY, p.getY(), 2.0) || !this.isInWater(p)) continue;
                p.giveExperiencePoints(addExp);
            }
        }
        if (this.process.tick()) {
            this.syncData();
        }
    }
}

