/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.fumarole;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.blocks.fumarole.FumaroleVentBlock;
import com.teammoeg.caupona.blocks.fumarole.PumiceBloomBlock;
import com.teammoeg.caupona.blocks.stove.IStove;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.LazyTickWorker;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class FumaroleVentBlockEntity
extends CPBaseBlockEntity
implements IStove {
    private final int heat;
    LazyTickWorker update;
    LazyTickWorker check;

    public FumaroleVentBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CPBlockEntityTypes.FUMAROLE.get(), pWorldPosition, pBlockState);
        this.heat = (Integer)CPConfig.SERVER.fumarolePower.get();
        this.check = new LazyTickWorker((Integer)CPConfig.SERVER.fumaroleCheck.get(), () -> {
            BlockState bs = this.getBlockState();
            BlockState below = this.getLevel().getBlockState(this.getBlockPos().below(2));
            int cheat = (Integer)bs.getValue((Property)FumaroleVentBlock.HEAT);
            if (below.is(CPTags.Blocks.FUMAROLE_VERY_HOT_BLOCK)) {
                if (cheat != 2) {
                    this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)bs.setValue((Property)FumaroleVentBlock.HEAT, (Comparable)Integer.valueOf(2)));
                }
            } else if (below.is(CPTags.Blocks.FUMAROLE_HOT_BLOCK)) {
                if (cheat != 1) {
                    this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)bs.setValue((Property)FumaroleVentBlock.HEAT, (Comparable)Integer.valueOf(1)));
                }
            } else if (cheat != 0) {
                this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)bs.setValue((Property)FumaroleVentBlock.HEAT, (Comparable)Integer.valueOf(0)));
            }
            return true;
        });
        this.update = new LazyTickWorker((Integer)CPConfig.SERVER.fumaroleSpeed.get(), () -> {
            if (!((Boolean)this.getBlockState().getValue((Property)FumaroleVentBlock.WATERLOGGED)).booleanValue()) {
                FumaroleVentBlockEntity.placeFumarole(this.getLevel(), this.getBlockPos());
            }
            return true;
        });
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        if (isClient) {
            return;
        }
        this.update.read(nbt, "update");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider registries) {
        if (isClient) {
            return;
        }
        this.update.write(nbt, "update");
    }

    @Override
    public void tick() {
        BlockState bs = this.getBlockState();
        if ((Integer)bs.getValue((Property)FumaroleVentBlock.HEAT) == 2) {
            this.update.tick();
            this.setChanged();
        }
        this.check.tick();
    }

    public static void placeFumarole(Level pLevel, BlockPos pPos) {
        RandomSource pRandom = pLevel.getRandom();
        int dx = (pRandom.nextBoolean() ? 1 : -1) * pRandom.nextInt(6);
        int dz = (pRandom.nextBoolean() ? 1 : -1) * pRandom.nextInt(6);
        if (dx == 0 && dz == 0) {
            return;
        }
        BlockPos pendPos = pPos.offset(dx, 0, dz);
        for (int i = 0; i < 3; ++i) {
            BlockState b0 = pLevel.getBlockState(pendPos);
            BlockState b1 = pLevel.getBlockState(pendPos.below());
            if (b0.isAir() && b1.getFluidState().is(CPTags.Fluids.PUMICE_ON)) {
                if (FumaroleVentBlockEntity.shouldPlacePumice(pLevel, pendPos)) {
                    pLevel.setBlockAndUpdate(pendPos, ((PumiceBloomBlock)((Object)CPBlocks.PUMICE_BLOOM.get())).defaultBlockState());
                }
                return;
            }
            pendPos = pendPos.below();
        }
    }

    public static boolean shouldPlacePumice(Level pLevel, BlockPos pPos) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return false;
        }
        int cnt = 0;
        AABB aabb = new AABB((double)(pPos.getX() - 1), (double)pPos.getY(), (double)(pPos.getZ() - 1), (double)(pPos.getX() + 1), (double)pPos.getY(), (double)(pPos.getZ() + 1));
        Iterator it = pLevel.getBlockStates(aabb).iterator();
        while (it.hasNext()) {
            if (((BlockState)it.next()).getBlock() == CPBlocks.PUMICE_BLOOM.get()) {
                ++cnt;
            }
            if (cnt < 2) continue;
            return false;
        }
        return true;
    }

    @Override
    public int requestHeat() {
        if (((Boolean)this.getBlockState().getValue((Property)FumaroleVentBlock.WATERLOGGED)).booleanValue()) {
            return 0;
        }
        return this.heat;
    }

    @Override
    public boolean canEmitHeat() {
        if (this.heat == 0) {
            return false;
        }
        if (((Boolean)this.getBlockState().getValue((Property)FumaroleVentBlock.WATERLOGGED)).booleanValue()) {
            return false;
        }
        return (Integer)this.getBlockState().getValue((Property)FumaroleVentBlock.HEAT) != 0;
    }
}

