/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.foods;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.blocks.foods.DishBlock;
import com.teammoeg.caupona.blocks.foods.IFoodContainer;
import com.teammoeg.caupona.item.DishItem;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.IInfinitable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DishBlockEntity
extends CPBaseBlockEntity
implements IInfinitable,
IFoodContainer {
    public ItemStack internal = ItemStack.EMPTY;
    boolean isInfinite = false;

    public DishBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CPBlockEntityTypes.DISH.get(), pWorldPosition, pBlockState);
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider ra) {
        this.internal = ItemStack.parseOptional((HolderLookup.Provider)ra, (CompoundTag)nbt.getCompound("bowl"));
        this.isInfinite = nbt.getBoolean("inf");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider ra) {
        nbt.put("bowl", this.internal.saveOptional(ra));
        nbt.putBoolean("inf", this.isInfinite);
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean setInfinity() {
        this.isInfinite = !this.isInfinite;
        return this.isInfinite;
    }

    @Override
    public ItemStack getInternal(int num) {
        return this.internal;
    }

    @Override
    public void setInternal(int num, ItemStack is) {
        if (!this.isInfinite) {
            this.internal = is;
            if (this.internal.is(Items.BOWL)) {
                this.getLevel().setBlockAndUpdate(this.getBlockPos(), ((DishBlock)CPBlocks.DISH.get()).defaultBlockState());
            } else {
                Item item = this.internal.getItem();
                if (item instanceof DishItem) {
                    DishItem dish = (DishItem)item;
                    this.getLevel().setBlockAndUpdate(this.getBlockPos(), dish.getBlock().defaultBlockState());
                }
            }
            this.syncData();
        }
    }

    @Override
    public int getSlots() {
        return 1;
    }

    @Override
    public boolean accepts(int num, ItemStack is) {
        return is.getItem() instanceof DishItem || is.is(Items.BOWL);
    }
}

