/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.foods;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.blocks.CPRegisteredEntityBlock;
import com.teammoeg.caupona.blocks.foods.DishBlockEntity;
import com.teammoeg.caupona.item.DishItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DishBlock
extends CPRegisteredEntityBlock<DishBlockEntity> {
    public static final IntegerProperty PAN = IntegerProperty.create((String)"pan", (int)0, (int)2);
    static final VoxelShape shape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public DishBlock(BlockBehaviour.Properties blockProps) {
        super(blockProps, CPBlockEntityTypes.DISH);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PAN, (Comparable)Integer.valueOf(0)));
        CPBlocks.dishes.add(this);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PAN});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)PAN, (Comparable)Integer.valueOf(0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.getBlock() instanceof DishBlock)) {
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity instanceof DishBlockEntity) {
                DishBlockEntity dish = (DishBlockEntity)blockEntity;
                CPRegisteredEntityBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)dish.internal);
            }
            worldIn.removeBlockEntity(pos);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionResult p = super.useWithoutItem(state, worldIn, pos, player, hit);
        if (p.consumesAction()) {
            return p;
        }
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof DishBlockEntity) {
            DishBlockEntity dish = (DishBlockEntity)blockEntity;
            if (dish.internal != null && dish.internal.getItem() instanceof DishItem && dish.internal.getFoodProperties(null) != null) {
                FoodProperties fp = dish.internal.getFoodProperties((LivingEntity)player);
                if (dish.isInfinite) {
                    if (player.canEat(fp.canAlwaysEat())) {
                        player.eat(worldIn, dish.internal.copy());
                        dish.syncData();
                    }
                } else if (player.canEat(fp.canAlwaysEat())) {
                    ItemStack iout = dish.internal.getCraftingRemainingItem();
                    player.eat(worldIn, dish.internal);
                    dish.internal = iout;
                    if (dish.internal.is(Items.BOWL)) {
                        worldIn.setBlockAndUpdate(pos, ((DishBlock)CPBlocks.DISH.get()).defaultBlockState());
                    } else {
                        worldIn.removeBlock(pos, false);
                    }
                    dish.syncData();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof DishBlockEntity) {
            DishBlockEntity dish = (DishBlockEntity)blockEntity;
            dish.internal = pStack.copyWithCount(1);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DishBlockEntity) {
            DishBlockEntity dish = (DishBlockEntity)blockEntity;
            if (dish.internal == null) {
                return ItemStack.EMPTY;
            }
            return dish.internal.copy();
        }
        return this.getCloneItemStack(state, target, level, pos, player);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof DishBlockEntity) {
            DishBlockEntity dish = (DishBlockEntity)blockEntity;
            if (dish.internal != null && !dish.internal.isEmpty() && dish.internal.getFoodProperties(null) != null) {
                return 15;
            }
        }
        return 0;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }
}

