/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.foods;

import com.teammoeg.caupona.blocks.CPRegisteredEntityBlock;
import com.teammoeg.caupona.blocks.foods.BowlBlockEntity;
import com.teammoeg.caupona.item.StewItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;

public class BowlBlock
extends CPRegisteredEntityBlock<BowlBlockEntity> {
    static final VoxelShape shape = Block.box((double)2.8, (double)0.0, (double)2.8, (double)13.2, (double)5.2, (double)13.2);

    public BowlBlock(BlockBehaviour.Properties blockProps, DeferredHolder<BlockEntityType<?>, BlockEntityType<BowlBlockEntity>> ste) {
        super(blockProps, ste);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof BowlBlockEntity) {
            BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
            CPRegisteredEntityBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)bowl.internal);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionResult p = super.useWithoutItem(state, worldIn, pos, player, hit);
        if (p.consumesAction()) {
            return p;
        }
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof BowlBlockEntity) {
            BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
            if (bowl.internal != null && bowl.internal.getItem() instanceof StewItem && bowl.internal.getFoodProperties((LivingEntity)player) != null) {
                FoodProperties fp = bowl.internal.getFoodProperties((LivingEntity)player);
                if (bowl.isInfinite) {
                    if (player.canEat(fp.canAlwaysEat())) {
                        player.eat(worldIn, bowl.internal.copy());
                        bowl.syncData();
                    }
                } else if (player.canEat(fp.canAlwaysEat())) {
                    ItemStack iout = bowl.internal.getCraftingRemainingItem();
                    player.eat(worldIn, bowl.internal);
                    bowl.internal = iout;
                    bowl.syncData();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof BowlBlockEntity) {
            BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
            bowl.internal = pStack.copyWithCount(1);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BowlBlockEntity) {
            BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
            if (bowl.internal == null) {
                return ItemStack.EMPTY;
            }
            return bowl.internal.copy();
        }
        return this.getCloneItemStack(state, target, level, pos, player);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof BowlBlockEntity) {
            BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
            if (bowl.internal != null && !bowl.internal.isEmpty() && bowl.internal.getFoodProperties(null) != null) {
                return 15;
            }
        }
        return 0;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }
}

