/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.dolium;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.blocks.dolium.DoliumContainer;
import com.teammoeg.caupona.components.StewInfo;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.data.recipes.DoliumRecipe;
import com.teammoeg.caupona.data.recipes.SpiceRecipe;
import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.IInfinitable;
import com.teammoeg.caupona.util.LazyTickWorker;
import com.teammoeg.caupona.util.SyncedFluidHandler;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public class CounterDoliumBlockEntity
extends CPBaseBlockEntity
implements MenuProvider,
IInfinitable {
    ItemStackHandler inv = new ItemStackHandler(this, 6){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < 3) {
                return DoliumRecipe.testInput(stack);
            }
            if (slot == 3) {
                return SpiceRecipe.isValid(stack);
            }
            return slot == 4;
        }
    };
    public final FluidTank tank = new FluidTank(1250, f -> !f.getFluid().getFluidType().isLighterThanAir()){

        protected void onContentsChanged() {
            super.onContentsChanged();
            CounterDoliumBlockEntity.this.process = -1;
        }
    };
    public int process;
    public int processMax;
    public LazyTickWorker contain;
    boolean isInfinite = false;
    ItemStack inner = ItemStack.EMPTY;
    RangedWrapper bowl = new RangedWrapper(this, (IItemHandlerModifiable)this.inv, 3, 6){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 5) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 3 || slot == 4) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    RangedWrapper ingredient = new RangedWrapper(this, (IItemHandlerModifiable)this.inv, 0, 3){

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }
    };
    IFluidHandler handler = new SyncedFluidHandler(this, new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int t) {
            if (t == 0) {
                return CounterDoliumBlockEntity.this.tank.getFluid();
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int t) {
            if (t == 0) {
                return CounterDoliumBlockEntity.this.tank.getCapacity();
            }
            return 0;
        }

        public boolean isFluidValid(int t, FluidStack stack) {
            return CounterDoliumBlockEntity.this.tank.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            CounterDoliumBlockEntity.this.process = -1;
            if (!CounterDoliumBlockEntity.this.isInfinite) {
                return CounterDoliumBlockEntity.this.tank.fill(resource, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            CounterDoliumBlockEntity.this.process = -1;
            if (CounterDoliumBlockEntity.this.isInfinite) {
                return action.simulate() ? resource : CounterDoliumBlockEntity.this.tryAddSpice(resource);
            }
            return action.simulate() ? CounterDoliumBlockEntity.this.tank.drain(resource, action) : CounterDoliumBlockEntity.this.tryAddSpice(CounterDoliumBlockEntity.this.tank.drain(resource, action));
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            CounterDoliumBlockEntity.this.process = -1;
            if (CounterDoliumBlockEntity.this.isInfinite) {
                return action.simulate() ? CounterDoliumBlockEntity.this.tank.getFluid().copyWithAmount(maxDrain) : CounterDoliumBlockEntity.this.tryAddSpice(CounterDoliumBlockEntity.this.tank.getFluid().copyWithAmount(maxDrain));
            }
            return action.simulate() ? CounterDoliumBlockEntity.this.tank.drain(maxDrain, action) : CounterDoliumBlockEntity.this.tryAddSpice(CounterDoliumBlockEntity.this.tank.drain(maxDrain, action));
        }
    });

    private FluidStack tryAddSpice(FluidStack fs) {
        SpiceRecipe spice = null;
        ItemStack spi = this.inv.getStackInSlot(3);
        if (fs.getAmount() % 250 == 0 && fs.getFluid() instanceof SoupFluid) {
            spice = SpiceRecipe.find(spi);
        }
        if (spice != null) {
            StewInfo si = Utils.getOrCreateInfo(fs);
            if (!si.canAddSpice()) {
                return fs;
            }
            if (!this.isInfinite) {
                int consume = fs.getAmount() / 250;
                if (SpiceRecipe.getMaxUse(spi) < consume) {
                    return fs;
                }
                this.inv.setStackInSlot(3, SpiceRecipe.handle(spi, consume));
            }
            si.addSpice(spice.effect, spi);
            Utils.setInfo((MutableDataComponentHolder)fs, si);
        }
        return fs;
    }

    public CounterDoliumBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CPBlockEntityTypes.DOLIUM.get(), pWorldPosition, pBlockState);
        this.processMax = (Integer)CPConfig.COMMON.staticTime.get();
        this.contain = new LazyTickWorker((Integer)CPConfig.SERVER.containerTick.get(), () -> {
            if (this.isInfinite) {
                FluidStack fs = this.tank.getFluid().copy();
                this.tryContianFluid();
                this.tank.setFluid(fs);
            } else if (this.tryContianFluid()) {
                return true;
            }
            return false;
        });
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider ra) {
        this.process = nbt.getInt("process");
        this.tank.readFromNBT(ra, nbt.getCompound("tank"));
        this.isInfinite = nbt.getBoolean("inf");
        if (!isClient) {
            this.inner = ItemStack.parseOptional((HolderLookup.Provider)ra, (CompoundTag)nbt.getCompound("inner"));
            this.inv.deserializeNBT(ra, nbt.getCompound("inventory"));
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient, HolderLookup.Provider ra) {
        nbt.putInt("process", this.process);
        nbt.put("tank", (Tag)this.tank.writeToNBT(ra, new CompoundTag()));
        nbt.putBoolean("inf", this.isInfinite);
        if (!isClient) {
            nbt.put("inventory", (Tag)this.inv.serializeNBT(ra));
            nbt.put("inner", this.inner.saveOptional(ra));
        }
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        if (!this.inner.isEmpty()) {
            this.inner = Utils.insertToOutput(this.inv, 5, this.inner);
            this.setChanged();
            return;
        }
        boolean updateNeeded = this.contain.tick();
        if (!(this.process >= 0 && this.process % 20 != 0 || this.isInfinite)) {
            if (DoliumRecipe.testDolium(this.tank.getFluid(), this.inv) != null) {
                if (this.process == -1) {
                    this.process = 0;
                    updateNeeded = true;
                }
            } else if (this.process != -1) {
                this.process = -1;
                updateNeeded = true;
            }
        }
        if (this.process >= 0 && !this.isInfinite) {
            ++this.process;
            if (this.process >= this.processMax) {
                DoliumRecipe recipe;
                this.process = -1;
                if (this.inner.isEmpty() && (recipe = DoliumRecipe.testDolium(this.tank.getFluid(), this.inv)) != null) {
                    this.inner = recipe.handleDolium(this.tank.getFluid(), this.inv);
                }
            }
            updateNeeded = true;
        }
        if (updateNeeded) {
            this.syncData();
        }
    }

    boolean tryAddFluid(FluidStack fs) {
        if (this.isInfinite) {
            return false;
        }
        int tryfill = this.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE);
        if (tryfill > 0) {
            if (tryfill == fs.getAmount()) {
                this.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                this.process = -1;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean tryContianFluid() {
        ItemStack is = this.inv.getStackInSlot(4);
        if (!is.isEmpty() && this.inv.getStackInSlot(5).isEmpty()) {
            RecipeHolder<BowlContainingRecipe> recipe;
            if (is.getItem() == Items.BOWL && this.tank.getFluidAmount() >= 250 && (recipe = BowlContainingRecipe.recipes.get(this.tank.getFluid().getFluid())) != null) {
                is.shrink(1);
                this.inv.setStackInSlot(5, ((BowlContainingRecipe)recipe.value()).handle(this.tryAddSpice(this.tank.drain(250, IFluidHandler.FluidAction.EXECUTE))));
                this.process = -1;
                return true;
            }
            FluidStack out = Utils.extractFluid(is);
            if (!out.isEmpty()) {
                if (this.tryAddFluid(out)) {
                    ItemStack ret = is.getCraftingRemainingItem();
                    is.shrink(1);
                    this.process = -1;
                    this.inv.setStackInSlot(5, ret);
                }
                return true;
            }
            FluidActionResult far = FluidUtil.tryFillContainer((ItemStack)is, (IFluidHandler)this.tank, (int)1250, null, (boolean)true);
            if (far.isSuccess()) {
                is.shrink(1);
                if (far.getResult() != null) {
                    this.process = -1;
                    this.inv.setStackInSlot(5, far.getResult());
                }
                return true;
            }
            if (!this.isInfinite && (far = FluidUtil.tryEmptyContainer((ItemStack)is, (IFluidHandler)this.tank, (int)1250, null, (boolean)true)).isSuccess()) {
                is.shrink(1);
                if (far.getResult() != null) {
                    this.process = -1;
                    this.inv.setStackInSlot(5, far.getResult());
                }
                return true;
            }
        }
        return false;
    }

    public AbstractContainerMenu createMenu(int p1, Inventory p2, Player p3) {
        return new DoliumContainer(p1, p2, this);
    }

    public Component getDisplayName() {
        return Utils.translate("container.caupona.counter_dolium.title");
    }

    @Override
    public boolean setInfinity() {
        this.isInfinite = !this.isInfinite;
        return this.isInfinite;
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    @Override
    public Object getCapability(BlockCapability<?, Direction> cap, Direction side) {
        if (cap == Capabilities.ItemHandler.BLOCK) {
            if (side == Direction.UP) {
                return this.ingredient;
            }
            return this.bowl;
        }
        if (cap == Capabilities.FluidHandler.BLOCK) {
            return this.handler;
        }
        return null;
    }
}

