/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.dolium;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.blocks.CPHorizontalEntityBlock;
import com.teammoeg.caupona.blocks.dolium.CounterDoliumBlockEntity;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class CounterDoliumBlock
extends CPHorizontalEntityBlock<CounterDoliumBlockEntity>
implements LiquidBlockContainer {
    static final VoxelShape shape = Shapes.or((VoxelShape)Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0)), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0))));

    public CounterDoliumBlock(BlockBehaviour.Properties p) {
        super(CPBlockEntityTypes.DOLIUM, p);
        CPBlocks.dolium.add((Block)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    public VoxelShape getVisualShape(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return Shapes.empty();
    }

    public ItemInteractionResult useItemOn(ItemStack held, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult p = super.useItemOn(held, state, worldIn, pos, player, hand, hit);
        if (p.consumesAction()) {
            return p;
        }
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof CounterDoliumBlockEntity) {
            CounterDoliumBlockEntity dolium = (CounterDoliumBlockEntity)blockEntity;
            if (held.isEmpty() && player.isShiftKeyDown()) {
                dolium.tank.setFluid(FluidStack.EMPTY);
                return ItemInteractionResult.SUCCESS;
            }
            FluidStack out = Utils.extractFluid(held);
            if (!out.isEmpty()) {
                if (dolium.tryAddFluid(out)) {
                    ItemStack ret = held.getCraftingRemainingItem();
                    held.shrink(1);
                    if (!player.addItem(ret)) {
                        player.drop(ret, false);
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
            }
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)dolium.tank)) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return p;
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionResult p = super.useWithoutItem(state, worldIn, pos, player, hit);
        if (p.consumesAction()) {
            return p;
        }
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof CounterDoliumBlockEntity) {
            CounterDoliumBlockEntity dolium = (CounterDoliumBlockEntity)blockEntity;
            if (!(worldIn.isClientSide || !player.getAbilities().instabuild && dolium.isInfinite)) {
                ((ServerPlayer)player).openMenu((MenuProvider)dolium, dolium.getBlockPos());
            }
        }
        return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
    }

    public boolean canPlaceLiquid(Player ps, BlockGetter w, BlockPos p, BlockState s, Fluid f) {
        BlockEntity blockEntity = w.getBlockEntity(p);
        if (blockEntity instanceof CounterDoliumBlockEntity) {
            CounterDoliumBlockEntity dolium = (CounterDoliumBlockEntity)blockEntity;
            return dolium.tank.fill(new FluidStack(f, 1000), IFluidHandler.FluidAction.SIMULATE) == 1000;
        }
        return false;
    }

    public boolean placeLiquid(LevelAccessor w, BlockPos p, BlockState s, FluidState f) {
        CounterDoliumBlockEntity dolium;
        BlockEntity blockEntity = w.getBlockEntity(p);
        return blockEntity instanceof CounterDoliumBlockEntity && (dolium = (CounterDoliumBlockEntity)blockEntity).tryAddFluid(new FluidStack(f.getType(), 1000));
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof CounterDoliumBlockEntity) {
            CounterDoliumBlockEntity dolium = (CounterDoliumBlockEntity)blockEntity;
            for (int i = 0; i < 6; ++i) {
                ItemStack is = dolium.inv.getStackInSlot(i);
                if (is.isEmpty()) continue;
                CPHorizontalEntityBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)is);
            }
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }
}

