/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.decoration.mosaic;

import com.google.common.collect.Lists;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.CPGui;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicBlock;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicItem;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicMaterial;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicPattern;
import com.teammoeg.caupona.components.MosaicData;
import com.teammoeg.caupona.container.CPBaseContainer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class TBenchMenu
extends CPBaseContainer<BlockEntity> {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.standalone();
    private final Level level;
    private List<ItemStack> recipes = Lists.newArrayList();
    private ItemStack input0 = ItemStack.EMPTY;
    private ItemStack input1 = ItemStack.EMPTY;
    private ItemStack input2 = ItemStack.EMPTY;
    long lastSoundTime;
    final Slot inputSlot0;
    final Slot inputSlot1;
    final Slot inputSlot2;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(3){

        public void setChanged() {
            super.setChanged();
            TBenchMenu.this.slotsChanged((Container)this);
            TBenchMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public TBenchMenu(int pContainerId, Inventory pPlayerInventory, FriendlyByteBuf buf) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.create((Level)pPlayerInventory.player.level(), (BlockPos)buf.readBlockPos()));
    }

    public TBenchMenu(int pContainerId, Inventory pPlayerInventory, final ContainerLevelAccess pAccess) {
        super((MenuType)CPGui.T_BENCH.get(), null, pContainerId, 4);
        this.access = pAccess;
        this.level = pPlayerInventory.player.level();
        this.inputSlot0 = this.addSlot(new Slot(this, this.container, 0, 20, 34){

            public boolean mayPlace(ItemStack input) {
                return input.is(CPTags.Items.MOSAIC_BASE) || input.is(((MosaicBlock)((Object)CPBlocks.MOSAIC.get())).asItem());
            }
        });
        this.inputSlot1 = this.addSlot(new Slot(this, this.container, 1, 20, 16){

            public boolean mayPlace(ItemStack input) {
                return MosaicMaterial.fromItem(input) != null;
            }
        });
        this.inputSlot2 = this.addSlot(new Slot(this, this.container, 2, 20, 52){

            public boolean mayPlace(ItemStack input) {
                return MosaicMaterial.fromItem(input) != null;
            }
        });
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 3, 143, 33){

            public boolean mayPlace(ItemStack p_40362_) {
                return false;
            }

            public void onTake(Player player, ItemStack is) {
                ItemStack itemstack;
                is.onCraftedBy(player.level(), player, is.getCount());
                TBenchMenu.this.resultContainer.awardUsedRecipes(player, this.getRelevantItems());
                ItemStack input0 = TBenchMenu.this.inputSlot0.getItem();
                if (input0.is(CPTags.Items.MOSAIC_BASE)) {
                    TBenchMenu.this.inputSlot1.remove(1);
                    TBenchMenu.this.inputSlot2.remove(1);
                }
                if (!(itemstack = TBenchMenu.this.inputSlot0.remove(1)).isEmpty()) {
                    TBenchMenu.this.setupResultSlot();
                }
                pAccess.execute((p_40364_, p_40365_) -> {
                    long l = p_40364_.getGameTime();
                    if (TBenchMenu.this.lastSoundTime != l) {
                        p_40364_.playSound((Player)null, p_40365_, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        TBenchMenu.this.lastSoundTime = l;
                    }
                });
                super.onTake(player, is);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(TBenchMenu.this.inputSlot0.getItem(), TBenchMenu.this.inputSlot1.getItem(), TBenchMenu.this.inputSlot2.getItem());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlot(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public List<ItemStack> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    @Override
    public boolean stillValid(Player pPlayer) {
        return TBenchMenu.stillValid((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)CPBlocks.T_BENCH.get()));
    }

    public boolean clickMenuButton(Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.selectedRecipeIndex.set(pId);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.recipes.size();
    }

    public void slotsChanged(Container pInventory) {
        ItemStack itemstack0 = this.inputSlot0.getItem();
        ItemStack itemstack1 = this.inputSlot1.getItem();
        ItemStack itemstack2 = this.inputSlot2.getItem();
        if (!(itemstack0.is(this.input0.getItem()) && itemstack1.is(this.input1.getItem()) && itemstack2.is(this.input2.getItem()))) {
            this.input0 = itemstack0.copy();
            this.input1 = itemstack1.copy();
            this.input2 = itemstack2.copy();
            this.setupRecipeList(pInventory, itemstack0);
        }
    }

    private void setupRecipeList(Container pContainer, ItemStack input0) {
        block6: {
            block5: {
                this.recipes.clear();
                this.selectedRecipeIndex.set(-1);
                this.resultSlot.set(ItemStack.EMPTY);
                if (!input0.is(CPTags.Items.MOSAIC_BASE)) break block5;
                MosaicMaterial m1 = MosaicMaterial.fromItem(this.inputSlot1.getItem());
                MosaicMaterial m2 = MosaicMaterial.fromItem(this.inputSlot2.getItem());
                if (m1 == null || m2 == null) break block6;
                for (MosaicPattern pat : MosaicPattern.values()) {
                    ItemStack is = new ItemStack((ItemLike)CPBlocks.MOSAIC.get());
                    MosaicItem.setMosaic(is, m1, m2, pat);
                    this.recipes.add(is);
                }
                break block6;
            }
            if (input0.is(((MosaicBlock)((Object)CPBlocks.MOSAIC.get())).asItem())) {
                @Nullable MosaicData tag = (MosaicData)this.inputSlot0.getItem().get(CPCapability.MOSAIC_DATA);
                if (tag == null) {
                    return;
                }
                MosaicMaterial m1 = tag.getMaterial1();
                MosaicMaterial m2 = tag.getMaterial2();
                if (m1 != null && m2 != null) {
                    for (MosaicPattern pat : MosaicPattern.values()) {
                        ItemStack is = new ItemStack((ItemLike)CPBlocks.MOSAIC.get());
                        MosaicItem.setMosaic(is, m1, m2, pat);
                        this.recipes.add(is);
                    }
                }
            }
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            ItemStack itemstack = this.recipes.get(this.selectedRecipeIndex.get()).copy();
            if (itemstack.isItemEnabled(this.level.enabledFeatures())) {
                this.resultContainer.setRecipeUsed(null);
                this.resultSlot.set(itemstack);
            } else {
                this.resultSlot.set(ItemStack.EMPTY);
            }
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public MenuType<?> getType() {
        return (MenuType)CPGui.T_BENCH.get();
    }

    public void registerUpdateListener(Runnable pListener) {
        this.slotUpdateListener = pListener;
    }

    public boolean canTakeItemForPickAll(ItemStack pStack, Slot pSlot) {
        return pSlot.container != this.resultContainer && super.canTakeItemForPickAll(pStack, pSlot);
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((p_40313_, p_40314_) -> this.clearContainer(pPlayer, this.container));
    }

    @Override
    public boolean quickMoveIn(ItemStack slotStack) {
        return this.moveItemStackTo(slotStack, 0, 3, false);
    }
}

