/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.decoration.mosaic;

import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.blocks.CPHorizontalBlock;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicItem;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicMaterial;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicPattern;
import com.teammoeg.caupona.components.MosaicData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import org.jetbrains.annotations.Nullable;

public class MosaicBlock
extends CPHorizontalBlock {
    public static final EnumProperty<MosaicMaterial> MATERIAL_1 = EnumProperty.create((String)"material_1", MosaicMaterial.class);
    public static final EnumProperty<MosaicMaterial> MATERIAL_2 = EnumProperty.create((String)"material_2", MosaicMaterial.class);
    public static final EnumProperty<MosaicMaterial>[] MATERIAL = new EnumProperty[]{MATERIAL_1, MATERIAL_2};
    public static final EnumProperty<MosaicPattern> PATTERN = EnumProperty.create((String)"pattern", MosaicPattern.class);

    public MosaicBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        CODEC = MosaicBlock.simpleCodec(MosaicBlock::new);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{MATERIAL_1}).add(new Property[]{MATERIAL_2}).add(new Property[]{PATTERN});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState bs = super.getStateForPlacement(pContext);
        @Nullable MosaicData tag = (MosaicData)pContext.getItemInHand().get(CPCapability.MOSAIC_DATA);
        if (tag == null) {
            return bs;
        }
        return tag.createBlock();
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder p_287596_) {
        ItemStack is = new ItemStack((ItemLike)CPBlocks.MOSAIC.get());
        MosaicItem.setMosaic(is, (MosaicMaterial)((Object)state.getValue(MATERIAL_1)), (MosaicMaterial)((Object)state.getValue(MATERIAL_2)), (MosaicPattern)((Object)state.getValue(PATTERN)));
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(is);
        return ret;
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState state) {
        ItemStack is = new ItemStack((ItemLike)CPBlocks.MOSAIC.get());
        MosaicItem.setMosaic(is, (MosaicMaterial)((Object)state.getValue(MATERIAL_1)), (MosaicMaterial)((Object)state.getValue(MATERIAL_2)), (MosaicPattern)((Object)state.getValue(PATTERN)));
        return is;
    }
}

