/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.decoration;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpokedFenceBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty EAST_WALL = BooleanProperty.create((String)"east");
    public static final BooleanProperty NORTH_WALL = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH_WALL = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST_WALL = BooleanProperty.create((String)"west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;

    public SpokedFenceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH_WALL, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST_WALL, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH_WALL, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST_WALL, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeByIndex = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(2.0f, 2.0f, 24.0f, 0.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape pBaseShape, boolean pHeight, VoxelShape pTallShape) {
        if (pHeight) {
            return Shapes.or((VoxelShape)pBaseShape, (VoxelShape)pTallShape);
        }
        return pBaseShape;
    }

    private Map<BlockState, VoxelShape> makeShapes(float pWidth, float pDepth, float pWallPostHeight, float pWallMinY, float pWallTallHeight) {
        float f = 8.0f - pWidth;
        float f1 = 8.0f + pWidth;
        float f2 = 8.0f - pDepth;
        float f3 = 8.0f + pDepth;
        VoxelShape voxelshape = Block.box((double)f, (double)0.0, (double)f, (double)f1, (double)pWallPostHeight, (double)f1);
        VoxelShape voxelshape5 = Block.box((double)f2, (double)pWallMinY, (double)0.0, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape6 = Block.box((double)f2, (double)pWallMinY, (double)f2, (double)f3, (double)pWallTallHeight, (double)16.0);
        VoxelShape voxelshape7 = Block.box((double)0.0, (double)pWallMinY, (double)f2, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape8 = Block.box((double)f2, (double)pWallMinY, (double)f2, (double)16.0, (double)pWallTallHeight, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean wallside : EAST_WALL.getPossibleValues()) {
            for (Boolean wallside1 : NORTH_WALL.getPossibleValues()) {
                for (Boolean wallside2 : WEST_WALL.getPossibleValues()) {
                    for (Boolean wallside3 : SOUTH_WALL.getPossibleValues()) {
                        VoxelShape voxelshape9 = voxelshape;
                        voxelshape9 = SpokedFenceBlock.applyWallShape(voxelshape9, wallside, voxelshape8);
                        voxelshape9 = SpokedFenceBlock.applyWallShape(voxelshape9, wallside2, voxelshape7);
                        voxelshape9 = SpokedFenceBlock.applyWallShape(voxelshape9, wallside1, voxelshape5);
                        voxelshape9 = SpokedFenceBlock.applyWallShape(voxelshape9, wallside3, voxelshape6);
                        BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)EAST_WALL, (Comparable)wallside)).setValue((Property)WEST_WALL, (Comparable)wallside2)).setValue((Property)NORTH_WALL, (Comparable)wallside1)).setValue((Property)SOUTH_WALL, (Comparable)wallside3);
                        builder.put((Object)((BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)voxelshape9);
                        builder.put((Object)((BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)voxelshape9);
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeByIndex.get(pState);
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.collisionShapeByIndex.get(pState);
    }

    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    private boolean connectsTo(BlockState pState, boolean pSideSolid, Direction pDirection) {
        Block block = pState.getBlock();
        boolean flag = block instanceof FenceGateBlock && FenceGateBlock.connectsToDirection((BlockState)pState, (Direction)pDirection);
        return pState.is(BlockTags.WALLS) || !SpokedFenceBlock.isExceptionForConnection((BlockState)pState) && pSideSolid || block instanceof IronBarsBlock || flag || block instanceof SpokedFenceBlock;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockPos blockpos1 = blockpos.north();
        BlockPos blockpos2 = blockpos.east();
        BlockPos blockpos3 = blockpos.south();
        BlockPos blockpos4 = blockpos.west();
        BlockState blockstate = levelreader.getBlockState(blockpos1);
        BlockState blockstate1 = levelreader.getBlockState(blockpos2);
        BlockState blockstate2 = levelreader.getBlockState(blockpos3);
        BlockState blockstate3 = levelreader.getBlockState(blockpos4);
        boolean flag = this.connectsTo(blockstate, blockstate.isFaceSturdy((BlockGetter)levelreader, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.connectsTo(blockstate1, blockstate1.isFaceSturdy((BlockGetter)levelreader, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.connectsTo(blockstate2, blockstate2.isFaceSturdy((BlockGetter)levelreader, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.connectsTo(blockstate3, blockstate3.isFaceSturdy((BlockGetter)levelreader, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        return this.updateShape(blockstate5, flag, flag1, flag2, flag3);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        if (pFacing == Direction.DOWN) {
            return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return pFacing == Direction.UP ? this.topUpdate(pState) : this.sideUpdate((LevelReader)pLevel, pState, pFacingPos, pFacingState, pFacing);
    }

    private static boolean isConnected(BlockState pState, BooleanProperty pHeightProperty) {
        return (Boolean)pState.getValue((Property)pHeightProperty);
    }

    private BlockState topUpdate(BlockState pState) {
        boolean flag = SpokedFenceBlock.isConnected(pState, NORTH_WALL);
        boolean flag1 = SpokedFenceBlock.isConnected(pState, EAST_WALL);
        boolean flag2 = SpokedFenceBlock.isConnected(pState, SOUTH_WALL);
        boolean flag3 = SpokedFenceBlock.isConnected(pState, WEST_WALL);
        return this.updateShape(pState, flag, flag1, flag2, flag3);
    }

    private BlockState sideUpdate(LevelReader pLevel, BlockState pFirstState, BlockPos pSecondPos, BlockState pSecondState, Direction pDir) {
        Direction direction = pDir.getOpposite();
        boolean flag = pDir == Direction.NORTH ? this.connectsTo(pSecondState, pSecondState.isFaceSturdy((BlockGetter)pLevel, pSecondPos, direction), direction) : SpokedFenceBlock.isConnected(pFirstState, NORTH_WALL);
        boolean flag1 = pDir == Direction.EAST ? this.connectsTo(pSecondState, pSecondState.isFaceSturdy((BlockGetter)pLevel, pSecondPos, direction), direction) : SpokedFenceBlock.isConnected(pFirstState, EAST_WALL);
        boolean flag2 = pDir == Direction.SOUTH ? this.connectsTo(pSecondState, pSecondState.isFaceSturdy((BlockGetter)pLevel, pSecondPos, direction), direction) : SpokedFenceBlock.isConnected(pFirstState, SOUTH_WALL);
        boolean flag3 = pDir == Direction.WEST ? this.connectsTo(pSecondState, pSecondState.isFaceSturdy((BlockGetter)pLevel, pSecondPos, direction), direction) : SpokedFenceBlock.isConnected(pFirstState, WEST_WALL);
        return this.updateShape(pFirstState, flag, flag1, flag2, flag3);
    }

    private BlockState updateShape(BlockState pState, boolean pNorthConnection, boolean pEastConnection, boolean pSouthConnection, boolean pWestConnection) {
        BlockState blockstate = this.updateSides(pState, pNorthConnection, pEastConnection, pSouthConnection, pWestConnection);
        return blockstate;
    }

    private BlockState updateSides(BlockState pState, boolean pNorthConnection, boolean pEastConnection, boolean pSouthConnection, boolean pWestConnection) {
        return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)NORTH_WALL, (Comparable)Boolean.valueOf(pNorthConnection))).setValue((Property)EAST_WALL, (Comparable)Boolean.valueOf(pEastConnection))).setValue((Property)SOUTH_WALL, (Comparable)Boolean.valueOf(pSouthConnection))).setValue((Property)WEST_WALL, (Comparable)Boolean.valueOf(pWestConnection));
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) == false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED});
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        switch (pRotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)NORTH_WALL, (Comparable)((Boolean)pState.getValue((Property)SOUTH_WALL)))).setValue((Property)EAST_WALL, (Comparable)((Boolean)pState.getValue((Property)WEST_WALL)))).setValue((Property)SOUTH_WALL, (Comparable)((Boolean)pState.getValue((Property)NORTH_WALL)))).setValue((Property)WEST_WALL, (Comparable)((Boolean)pState.getValue((Property)EAST_WALL)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)NORTH_WALL, (Comparable)((Boolean)pState.getValue((Property)EAST_WALL)))).setValue((Property)EAST_WALL, (Comparable)((Boolean)pState.getValue((Property)SOUTH_WALL)))).setValue((Property)SOUTH_WALL, (Comparable)((Boolean)pState.getValue((Property)WEST_WALL)))).setValue((Property)WEST_WALL, (Comparable)((Boolean)pState.getValue((Property)NORTH_WALL)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)NORTH_WALL, (Comparable)((Boolean)pState.getValue((Property)WEST_WALL)))).setValue((Property)EAST_WALL, (Comparable)((Boolean)pState.getValue((Property)NORTH_WALL)))).setValue((Property)SOUTH_WALL, (Comparable)((Boolean)pState.getValue((Property)EAST_WALL)))).setValue((Property)WEST_WALL, (Comparable)((Boolean)pState.getValue((Property)SOUTH_WALL)));
            }
        }
        return pState;
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        switch (pMirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)pState.setValue((Property)NORTH_WALL, (Comparable)((Boolean)pState.getValue((Property)SOUTH_WALL)))).setValue((Property)SOUTH_WALL, (Comparable)((Boolean)pState.getValue((Property)NORTH_WALL)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)pState.setValue((Property)EAST_WALL, (Comparable)((Boolean)pState.getValue((Property)WEST_WALL)))).setValue((Property)WEST_WALL, (Comparable)((Boolean)pState.getValue((Property)EAST_WALL)));
            }
        }
        return super.mirror(pState, pMirror);
    }
}

