/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.decoration;

import com.teammoeg.caupona.blocks.decoration.CPRoadBlock;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CPRoadSideBlock
extends CPRoadBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    protected static final VoxelShape OCTET_NW = Block.box((double)0.0, (double)14.0, (double)0.0, (double)6.0, (double)24.0, (double)6.0);
    protected static final VoxelShape OCTET_SW = Block.box((double)0.0, (double)14.0, (double)10.0, (double)6.0, (double)24.0, (double)16.0);
    protected static final VoxelShape OCTET_NE = Block.box((double)10.0, (double)14.0, (double)0.0, (double)16.0, (double)24.0, (double)6.0);
    protected static final VoxelShape OCTET_SE = Block.box((double)10.0, (double)14.0, (double)10.0, (double)16.0, (double)24.0, (double)16.0);
    protected static final VoxelShape OCTET_N = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)24.0, (double)6.0);
    protected static final VoxelShape OCTET_W = Block.box((double)0.0, (double)14.0, (double)0.0, (double)6.0, (double)24.0, (double)16.0);
    protected static final VoxelShape OCTET_E = Block.box((double)10.0, (double)14.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);
    protected static final VoxelShape OCTET_S = Block.box((double)0.0, (double)14.0, (double)10.0, (double)16.0, (double)24.0, (double)16.0);
    protected static final VoxelShape[] BOTTOM_SHAPES = CPRoadSideBlock.makeShapes();
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] makeShapes() {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_56945_ -> CPRoadSideBlock.makeStairShape(p_56945_)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape makeStairShape(int pBitfield) {
        VoxelShape voxelshape = BASE_AABB;
        if ((pBitfield & 1) != 0) {
            if ((pBitfield & 2) != 0) {
                voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)OCTET_N);
            }
            if ((pBitfield & 4) != 0) {
                voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)OCTET_W);
            }
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)OCTET_NW);
        }
        if ((pBitfield & 8) != 0) {
            if ((pBitfield & 2) != 0) {
                voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)OCTET_E);
            }
            if ((pBitfield & 4) != 0) {
                voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)OCTET_S);
            }
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)OCTET_SE);
        }
        if ((pBitfield & 2) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)OCTET_NE);
        }
        if ((pBitfield & 4) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)OCTET_SW);
        }
        return voxelshape;
    }

    public CPRoadSideBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return BASE_AABB;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return BOTTOM_SHAPES[SHAPE_BY_STATE[this.getShapeIndex(pState)]];
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    private int getShapeIndex(BlockState pState) {
        return ((StairsShape)pState.getValue(SHAPE)).ordinal() * 4 + ((Direction)pState.getValue((Property)FACING)).get2DDataValue();
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.getClickedPos();
        BlockState blockstate = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(pContext.getPlayer().isShiftKeyDown() ? pContext.getHorizontalDirection() : pContext.getHorizontalDirection().getOpposite()));
        return (BlockState)blockstate.setValue(SHAPE, (Comparable)CPRoadSideBlock.getStairsShape(blockstate, (BlockGetter)pContext.getLevel(), blockpos));
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing.getAxis().isHorizontal() ? (BlockState)pState.setValue(SHAPE, (Comparable)CPRoadSideBlock.getStairsShape(pState, (BlockGetter)pLevel, pCurrentPos)) : pState;
    }

    public static boolean isRoadBlock(BlockState pState) {
        return pState.getBlock() instanceof CPRoadSideBlock;
    }

    private static StairsShape getStairsShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)pState.getValue((Property)FACING);
        BlockState blockstate = pLevel.getBlockState(pPos.relative(direction));
        if (CPRoadSideBlock.isRoadBlock(blockstate) && (direction1 = (Direction)blockstate.getValue((Property)FACING)).getAxis() != ((Direction)pState.getValue((Property)FACING)).getAxis() && CPRoadSideBlock.canTakeShape(pState, pLevel, pPos, direction1.getOpposite())) {
            if (direction1 == direction.getCounterClockWise()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = pLevel.getBlockState(pPos.relative(direction.getOpposite()));
        if (CPRoadSideBlock.isRoadBlock(blockstate1) && (direction2 = (Direction)blockstate1.getValue((Property)FACING)).getAxis() != ((Direction)pState.getValue((Property)FACING)).getAxis() && CPRoadSideBlock.canTakeShape(pState, pLevel, pPos, direction2)) {
            if (direction2 == direction.getCounterClockWise()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pFace) {
        BlockState blockstate = pLevel.getBlockState(pPos.relative(pFace));
        return !CPRoadSideBlock.isRoadBlock(blockstate) || blockstate.getValue((Property)FACING) != pState.getValue((Property)FACING);
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        StairsShape stairsshape = (StairsShape)pState.getValue(SHAPE);
        switch (pMirror) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return pState.rotate(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return pState.rotate(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.mirror(pState, pMirror);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, SHAPE});
    }

    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

