/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.api;

import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.components.IFoodInfo;
import com.teammoeg.caupona.components.StewInfo;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class CauponaHooks {
    public static final ResourceLocation stew = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"stews");

    private CauponaHooks() {
    }

    public static Optional<List<FloatemStack>> getItems(ItemStack stack) {
        IFoodInfo fi = (IFoodInfo)CPCapability.FOOD_INFO.getCapability(stack, null);
        if (fi != null) {
            return Optional.of(fi.getStacks());
        }
        @Nullable IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (cap != null) {
            IFluidHandlerItem data = cap;
            FluidStack fs = data.getFluidInTank(0);
            return Optional.of(Utils.getOrCreateInfo(fs).getStacks());
        }
        return Optional.empty();
    }

    public static Fluid getBase(ItemStack stack) {
        @Nullable IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (cap != null) {
            IFluidHandlerItem data = cap;
            return Utils.getOrCreateInfo((FluidStack)data.getFluidInTank((int)0)).base;
        }
        @Nullable StewInfo data = (StewInfo)stack.get(CPCapability.STEW_INFO);
        if (data != null) {
            return data.base;
        }
        return Fluids.EMPTY;
    }

    public static Optional<IFoodInfo> getInfo(ItemStack stack) {
        IFoodInfo fi = (IFoodInfo)CPCapability.FOOD_INFO.getCapability(stack, null);
        if (fi != null) {
            return Optional.of(fi);
        }
        @Nullable IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (cap != null) {
            IFluidHandlerItem data = cap;
            return Optional.of(Utils.getOrCreateInfo(data.getFluidInTank(0)));
        }
        return Optional.empty();
    }
}

