/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.api;

import com.teammoeg.caupona.api.events.ContanerContainFoodEvent;
import com.teammoeg.caupona.components.IFoodInfo;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.util.Utils;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class CauponaApi {
    private CauponaApi() {
    }

    public static void apply(Level worldIn, LivingEntity entityLiving, IFoodInfo info) {
        if (!worldIn.isClientSide) {
            RandomSource r = entityLiving.getRandom();
            for (FoodProperties.PossibleEffect ef : info.getEffects()) {
                if (!(r.nextFloat() < ef.probability())) continue;
                entityLiving.addEffect(ef.effect());
            }
            if (entityLiving instanceof Player) {
                Player player = (Player)entityLiving;
                player.getFoodData().eat(info.getHealing(), info.getSaturation());
            }
        }
    }

    public static Optional<ItemStack> fillBowl(IFluidHandler handler) {
        FluidStack stack = handler.drain(250, IFluidHandler.FluidAction.SIMULATE);
        if (stack.getAmount() == 250) {
            return CauponaApi.fillBowl(handler.drain(250, IFluidHandler.FluidAction.EXECUTE));
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getFilledItemStack(IFluidHandler handler, ItemStack in) {
        FluidStack stack = handler.drain(250, IFluidHandler.FluidAction.SIMULATE);
        ContanerContainFoodEvent ev = Utils.contain(in, stack, true);
        if (ev.isAllowed()) {
            return CauponaApi.getFilledItemStack(handler.drain(ev.drainAmount, IFluidHandler.FluidAction.EXECUTE), in);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getFilledItemStack(FluidStack stack, ItemStack in) {
        ContanerContainFoodEvent ev = Utils.contain(in, stack, false);
        if (ev.isAllowed()) {
            return Optional.of(ev.out);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> fillBowl(FluidStack stack) {
        if (stack.getAmount() != 250) {
            return Optional.empty();
        }
        RecipeHolder<BowlContainingRecipe> recipe = BowlContainingRecipe.recipes.get(stack.getFluid());
        if (recipe != null) {
            ItemStack ret = ((BowlContainingRecipe)recipe.value()).handle(stack);
            return Optional.of(ret);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getBlockFilledItemStack(Fluid f, ItemStack is) {
        FluidStack stack = new FluidStack(f, 250);
        ContanerContainFoodEvent ev = Utils.containBlock(is, stack);
        if (ev.isAllowed()) {
            return Optional.of(ev.out);
        }
        return Optional.empty();
    }
}

