/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona;

import com.google.common.collect.ImmutableSet;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.fluid.SoupFluid;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class CPFluids {
    private static final ResourceLocation STILL_WATER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"block/water_still");
    private static final ResourceLocation STILL_SOUP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"block/soup_fluid");
    private static final ResourceLocation STILL_MILK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"block/milk_still");
    static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"caupona");
    static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)"caupona");

    public static TextureColorPair soup(int c) {
        return new TextureColorPair(STILL_SOUP_TEXTURE, c);
    }

    public static TextureColorPair water(int c) {
        return new TextureColorPair(STILL_WATER_TEXTURE, c);
    }

    public static TextureColorPair milk(int c) {
        return new TextureColorPair(STILL_MILK_TEXTURE, c);
    }

    public static Stream<Fluid> getAll() {
        return Arrays.stream(CPItems.soups).map(e -> ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)e)).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).get(arg_0));
    }

    public static Stream<ResourceKey<Fluid>> getAllKeys() {
        return Arrays.stream(CPItems.soups).map(e -> ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)e)).map(e -> ResourceKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)e));
    }

    public static Set<String> getSoupfluids() {
        return ImmutableSet.copyOf((Object[])CPItems.soups);
    }

    static {
        for (String i : CPItems.soups) {
            DeferredHolder type = FLUID_TYPES.register(i, () -> new FluidType(FluidType.Properties.create().viscosity(1200).temperature(333).rarity(Rarity.UNCOMMON).descriptionId("item.caupona." + i)));
            LazySupplier crf = new LazySupplier();
            crf.setVal(FLUIDS.register(i, () -> new SoupFluid(new BaseFlowingFluid.Properties((Supplier)type, (Supplier)crf, (Supplier)crf).slopeFindDistance(1).explosionResistance(100.0f))));
        }
    }

    private static class TextureColorPair {
        ResourceLocation texture;
        int c;

        public TextureColorPair(ResourceLocation t, int c) {
            this.texture = t;
            this.c = c;
        }

        public FluidType create(String n) {
            FluidType ft = new FluidType(FluidType.Properties.create().viscosity(1200).temperature(333).rarity(Rarity.UNCOMMON).descriptionId("item.caupona." + n));
            return ft;
        }
    }

    public static class LazySupplier<T>
    implements Supplier<T> {
        Supplier<T> val;

        @Override
        public T get() {
            if (this.val == null) {
                return null;
            }
            return this.val.get();
        }

        public void setVal(Supplier<T> val) {
            this.val = val;
        }
    }
}

