/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona;

import java.util.ArrayList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CPConfig {
    public static final ModConfigSpec COMMON_CONFIG;
    public static final ModConfigSpec SERVER_CONFIG;
    public static final Common COMMON;
    public static final Server SERVER;
    public static ArrayList<String> DEFAULT_WHITELIST;

    public static void register() {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
    }

    static {
        DEFAULT_WHITELIST = new ArrayList();
        ModConfigSpec.Builder COMMON_BUILDER = new ModConfigSpec.Builder();
        COMMON = new Common(COMMON_BUILDER);
        COMMON_CONFIG = COMMON_BUILDER.build();
        ModConfigSpec.Builder SERVER_BUILDER = new ModConfigSpec.Builder();
        SERVER = new Server(SERVER_BUILDER);
        SERVER_CONFIG = SERVER_BUILDER.build();
    }

    public static class Common {
        public ModConfigSpec.ConfigValue<Integer> staticTime;
        public ModConfigSpec.ConfigValue<Double> roadSpeedAddtion;

        Common(ModConfigSpec.Builder builder) {
            builder.push("recipe");
            this.staticTime = builder.comment("Ticks before do still recipe").defineInRange("StillRecipeTicks", 12000, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("road");
            this.roadSpeedAddtion = builder.comment("Additional speed added per tick for roads").defineInRange("roadSpeedAddtion", 2.0, 0.0, 10.0);
            builder.pop();
        }
    }

    public static class Server {
        public ModConfigSpec.ConfigValue<Integer> chimneyTicks;
        public ModConfigSpec.ConfigValue<Integer> chimneyCheck;
        public ModConfigSpec.ConfigValue<Integer> chimneyStorage;
        public ModConfigSpec.ConfigValue<Integer> stoveCD;
        public ModConfigSpec.ConfigValue<Integer> fumaroleSpeed;
        public ModConfigSpec.ConfigValue<Integer> fumaroleCheck;
        public ModConfigSpec.ConfigValue<Integer> fumarolePower;
        public ModConfigSpec.ConfigValue<Double> stoveFuel;
        public ModConfigSpec.ConfigValue<Integer> potCookTimeBase;
        public ModConfigSpec.ConfigValue<Integer> potMixTimeBase;
        public ModConfigSpec.ConfigValue<Integer> fryTimeBase;
        public ModConfigSpec.ConfigValue<Integer> containerTick;
        public ModConfigSpec.ConfigValue<Integer> bathExp;
        public ModConfigSpec.ConfigValue<Double> bathChance;
        public ModConfigSpec.ConfigValue<Integer> bathPath;
        public ModConfigSpec.ConfigValue<Integer> wolfTick;
        public ModConfigSpec.ConfigValue<Integer> bathRange;
        public ModConfigSpec.ConfigValue<Boolean> genCH;
        public ModConfigSpec.ConfigValue<Boolean> strictWater;
        public ModConfigSpec.ConfigValue<Double> benefitialMod;
        public ModConfigSpec.ConfigValue<Double> harmfulMod;
        public ModConfigSpec.ConfigValue<Double> leadenGenRate;
        public ModConfigSpec.ConfigValue<Boolean> addManual;

        Server(ModConfigSpec.Builder builder) {
            builder.push("recipes");
            this.potCookTimeBase = builder.comment("Stew pot cooking mininum time in ticks").defineInRange("potCookMinTicks", 100, 1, Integer.MAX_VALUE);
            this.potMixTimeBase = builder.comment("Stew pot mixture mininum time in ticks").defineInRange("potMixMinTicks", 50, 1, Integer.MAX_VALUE);
            this.fryTimeBase = builder.comment("Pan frying mininum time in ticks").defineInRange("fryMinTicks", 100, 1, Integer.MAX_VALUE);
            this.containerTick = builder.comment("Tick interval between container input check").defineInRange("containTick", 10, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("chimney");
            this.chimneyTicks = builder.comment("How many ticks does a chimney pot needed to make a soot").define("ChimneySootTicks", (Object)80);
            this.chimneyCheck = builder.comment("Interval in ticks for a chimney to check it's validity").defineInRange("ChimneyCheckTicks", 20, 1, Integer.MAX_VALUE);
            this.chimneyStorage = builder.comment("Max soot stored in a chimney").defineInRange("ChimneySootStorage", 8, 1, 64);
            builder.pop();
            builder.push("stoves");
            this.stoveCD = builder.comment("How many ticks should the stove pause burning when work is done").define("StovePauseTimer", (Object)100);
            this.stoveFuel = builder.comment("Stove fuel value multiplier").define("StoveFuelMultiplier", (Object)1.0);
            builder.pop();
            builder.push("fumarole");
            this.fumaroleSpeed = builder.comment("Interval in ticks for a  fumarole vent to generate pumice bloom").defineInRange("FumaroleTicks", 100, 1, Integer.MAX_VALUE);
            this.fumaroleCheck = builder.comment("Interval in ticks for a fumarole vent to check its heat source").defineInRange("FumaroleCheckTicks", 20, 1, Integer.MAX_VALUE);
            this.fumarolePower = builder.comment("Fumarole heat value, set to 0 to disable fumarole heat.").defineInRange("FumaroleHeat", 1, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("hypocast");
            builder.comment("Actual expectation of experience per tick is change x exp");
            this.bathExp = builder.comment("How many exp add to bathing play when conditions meet, set 0 to disable").defineInRange("BathExperience", 1, 0, Integer.MAX_VALUE);
            this.bathChance = builder.comment("The chance add the exp to player per tick per caliduct block").defineInRange("BathGetExpChance", (double)0.005f, 0.0, 1.0);
            this.bathPath = builder.comment("Interval for bath heat check").defineInRange("BathHeatTicks", 20, 1, Integer.MAX_VALUE);
            this.wolfTick = builder.comment("Interval for wolf statue heat check").defineInRange("WolfTicks", 10, 1, Integer.MAX_VALUE);
            this.bathRange = builder.comment("Firebox heat conduct radius").defineInRange("FireboxRadius", 4, 0, Integer.MAX_VALUE);
            this.strictWater = builder.comment("Strict player in water check, player must be in water to get bonus.").define("StrictInWaterCheck", true);
            builder.pop();
            builder.push("misc");
            this.genCH = builder.comment("Super secret special content").define("specialContents", true);
            this.addManual = builder.comment("Add manual to player on start").define("addManual", true);
            this.leadenGenRate = builder.comment("Leaden walnut tranformation rate").defineInRange("leadenGenRate", 0.05, 0.0, 1.0);
            builder.pop();
            builder.push("compat");
            builder.push("diet");
            builder.comment("You would only need to modify this when diet mod installed, otherwist this does not take effect");
            this.benefitialMod = builder.comment("Benefitial diet value modifier for cooking food into stew").define("benefitialModifier", (Object)1.2);
            this.harmfulMod = builder.comment("Harmful diet value modifier for cooking food into stew").define("harmfulModifier", (Object)0.8);
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        public ModConfigSpec.ConfigValue<Boolean> fancyPan;

        Client(ModConfigSpec.Builder builder) {
        }
    }
}

