/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona;

import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.api.CauponaApi;
import com.teammoeg.caupona.api.events.ContanerContainFoodEvent;
import com.teammoeg.caupona.api.events.EventResult;
import com.teammoeg.caupona.api.events.FoodExchangeItemEvent;
import com.teammoeg.caupona.components.StewInfo;
import com.teammoeg.caupona.data.RecipeReloadListener;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.util.ITickableContainer;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import vazkii.patchouli.api.PatchouliAPI;

@EventBusSubscriber
public class CPCommonEvents {
    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new RecipeReloadListener(event.getServerResources()));
    }

    @SubscribeEvent
    public static void isExtractAllowed(FoodExchangeItemEvent.Pre event) {
        if (!event.getOrigin().is(Items.BOWL)) {
            event.setResult(EventResult.ALLOW);
        }
    }

    @SubscribeEvent
    public static void isExchangeAllowed(FoodExchangeItemEvent.Post event) {
        if (!event.getOrigin().is(Items.BOWL) && event.getTarget().is(Items.BOWL)) {
            event.setResult(EventResult.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        AbstractContainerMenu abstractContainerMenu = event.getEntity().containerMenu;
        if (abstractContainerMenu instanceof ITickableContainer) {
            ITickableContainer container = (ITickableContainer)abstractContainerMenu;
            container.tick(event.getEntity() instanceof ServerPlayer);
        }
    }

    @SubscribeEvent
    public static void bowlContainerFood(ContanerContainFoodEvent ev) {
        RecipeHolder<BowlContainingRecipe> recipe;
        if (ev.origin.getItem() == Items.BOWL && (recipe = BowlContainingRecipe.recipes.get(ev.fs.getFluid())) != null) {
            ev.out = ((BowlContainingRecipe)recipe.value()).handle(ev.fs);
            ev.setResult(EventResult.ALLOW);
        }
    }

    @SubscribeEvent
    public static void addManualToPlayer(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundTag persistent;
        if (!((Boolean)CPConfig.SERVER.addManual.get()).booleanValue() || !ModList.get().isLoaded("patchouli")) {
            return;
        }
        CompoundTag nbt = event.getEntity().getPersistentData();
        if (nbt.contains("PlayerPersisted")) {
            persistent = nbt.getCompound("PlayerPersisted");
        } else {
            persistent = new CompoundTag();
            nbt.put("PlayerPersisted", (Tag)persistent);
        }
        if (!persistent.contains("caupona:book_given")) {
            persistent.putBoolean("caupona:book_given", true);
            ItemHandlerHelper.giveItemToPlayer((Player)event.getEntity(), (ItemStack)PatchouliAPI.get().getBookStack(ResourceLocation.fromNamespaceAndPath((String)"caupona", (String)"book")));
        }
    }

    @SubscribeEvent
    public static void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        Optional<ItemStack> out;
        IFluidHandler handler;
        BlockPos blockpos;
        ItemStack is = event.getItemStack();
        Player playerIn = event.getEntity();
        Level worldIn = event.getLevel();
        BlockEntity blockEntity = worldIn.getBlockEntity(blockpos = event.getPos());
        if (blockEntity != null && (handler = (IFluidHandler)worldIn.getCapability(Capabilities.FluidHandler.BLOCK, blockpos, (Object)event.getFace())) != null && (out = CauponaApi.getFilledItemStack(handler, is)).isPresent()) {
            ItemStack ret = out.get();
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)worldIn.isClientSide));
            if (is.getCount() > 1) {
                is.shrink(1);
                if (!playerIn.addItem(ret)) {
                    playerIn.drop(ret, false);
                }
            } else {
                playerIn.setItemInHand(event.getHand(), ret);
            }
        }
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        Optional<ItemStack> out;
        BlockPos blockpos;
        BlockState blockstate1;
        Fluid f;
        Player playerIn;
        ItemStack is = event.getItemStack();
        Level worldIn = event.getLevel();
        BlockHitResult ray = Item.getPlayerPOVHitResult((Level)worldIn, (Player)(playerIn = event.getEntity()), (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (ray.getType() == HitResult.Type.BLOCK && (f = (blockstate1 = worldIn.getBlockState(blockpos = ray.getBlockPos())).getFluidState().getType()) != Fluids.EMPTY && (out = CauponaApi.getBlockFilledItemStack(f, is)).isPresent()) {
            ItemStack ret = out.get();
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)worldIn.isClientSide));
            if (is.getCount() > 1) {
                is.shrink(1);
                if (!playerIn.addItem(ret)) {
                    playerIn.drop(ret, false);
                }
            } else {
                playerIn.setItemInHand(event.getHand(), ret);
            }
        }
    }

    @SubscribeEvent
    public static void onBowlUse(PlayerInteractEvent.RightClickItem event) {
        IFluidHandlerItem data;
        StewInfo si;
        ItemStack stack;
        IFluidHandlerItem cap;
        if (event.getEntity() != null && !event.getEntity().level().isClientSide && event.getEntity() instanceof ServerPlayer && (cap = (IFluidHandlerItem)(stack = event.getItemStack()).getCapability(Capabilities.FluidHandler.ITEM)) != null && stack.is(CPTags.Items.CONTAINER) && (si = (StewInfo)(data = cap).getFluidInTank(0).get(CPCapability.STEW_INFO)) != null && !event.getEntity().canEat(si.canAlwaysEat())) {
            event.setCancellationResult(InteractionResult.FAIL);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        IFluidHandlerItem data;
        StewInfo si;
        ItemStack stack;
        IFluidHandlerItem cap;
        if (event.getEntity() != null && !event.getEntity().level().isClientSide && event.getEntity() instanceof ServerPlayer && (cap = (IFluidHandlerItem)(stack = event.getItem()).getCapability(Capabilities.FluidHandler.ITEM)) != null && stack.is(CPTags.Items.CONTAINER) && (si = (StewInfo)(data = cap).getFluidInTank(0).get(CPCapability.STEW_INFO)) != null) {
            CauponaApi.apply(event.getEntity().level(), event.getEntity(), si);
        }
    }
}

