/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona;

import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPCapability;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.api.CauponaApi;
import com.teammoeg.caupona.api.events.ContanerContainFoodEvent;
import com.teammoeg.caupona.blocks.dolium.CounterDoliumBlockEntity;
import com.teammoeg.caupona.blocks.foods.IFoodContainer;
import com.teammoeg.caupona.blocks.pan.GravyBoatBlock;
import com.teammoeg.caupona.blocks.pan.PanBlockEntity;
import com.teammoeg.caupona.blocks.pot.StewPotBlockEntity;
import com.teammoeg.caupona.components.IFoodInfo;
import com.teammoeg.caupona.entity.CPBoat;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.CreativeTabItemHelper;
import com.teammoeg.caupona.util.FluidItemWrapper;
import com.teammoeg.caupona.util.ICreativeModeTabItem;
import com.teammoeg.caupona.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import net.neoforged.neoforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="caupona", bus=EventBusSubscriber.Bus.MOD)
public class CPCommonBootStrap {
    public static final List<Pair<Supplier<? extends ItemLike>, Float>> compositables = new ArrayList<Pair<Supplier<? extends ItemLike>, Float>>();
    public static final List<Pair<Supplier<? extends Block>, Pair<Integer, Integer>>> flamables = new ArrayList<Pair<Supplier<? extends Block>, Pair<Integer, Integer>>>();

    @SubscribeEvent
    public static void onCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        CreativeTabItemHelper helper = new CreativeTabItemHelper((ResourceKey<CreativeModeTab>)event.getTabKey(), event.getTab());
        CPItems.ITEMS.getEntries().forEach(e -> {
            Object patt0$temp = e.get();
            if (patt0$temp instanceof ICreativeModeTabItem) {
                ICreativeModeTabItem item = (ICreativeModeTabItem)patt0$temp;
                item.fillItemCategory(helper);
            }
        });
        helper.register((CreativeModeTab.Output)event);
    }

    @SubscribeEvent
    public static void onCapabilityInject(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, o) -> new FluidHandlerItemStack(CPCapability.SIMPLE_FLUID, stack, 1250), new ItemLike[]{(ItemLike)CPItems.situla.get()});
        event.registerItem(CPCapability.FOOD_INFO, (stack, o) -> (IFoodInfo)stack.get((DataComponentType)CPCapability.STEW_INFO.get()), (ItemLike[])CPItems.stews.toArray(Item[]::new));
        event.registerItem(CPCapability.FOOD_INFO, (stack, o) -> (IFoodInfo)stack.get((DataComponentType)CPCapability.SAUTEED_INFO.get()), (ItemLike[])CPItems.dish.toArray(Item[]::new));
        CPBlockEntityTypes.REGISTER.getEntries().stream().map(t -> (BlockEntityType)t.get()).forEach(be -> {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, be, (block, ctx) -> (IItemHandler)((CPBaseBlockEntity)((Object)((Object)block))).getCapability((BlockCapability<?, Direction>)Capabilities.ItemHandler.BLOCK, (Direction)ctx));
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, be, (block, ctx) -> (IFluidHandler)((CPBaseBlockEntity)((Object)((Object)block))).getCapability((BlockCapability<?, Direction>)Capabilities.FluidHandler.BLOCK, (Direction)ctx));
        });
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, o) -> new FluidItemWrapper((ItemStack)stack), (ItemLike[])CPItems.stews.toArray(Item[]::new));
    }

    public static <R extends ItemLike, T extends R> DeferredHolder<R, T> asCompositable(DeferredHolder<R, T> obj, float val) {
        compositables.add((Pair<Supplier<? extends ItemLike>, Float>)Pair.of(obj, (Object)Float.valueOf(val)));
        return obj;
    }

    public static <R extends Block, T extends R> DeferredHolder<R, T> asFlamable(DeferredHolder<R, T> obj, int v1, int v2) {
        flamables.add((Pair<Supplier<? extends Block>, Pair<Integer, Integer>>)Pair.of(obj, (Object)Pair.of((Object)v1, (Object)v2)));
        return obj;
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        CPCommonBootStrap.registerDispensers();
        compositables.forEach(p -> ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)((Supplier)p.getFirst()).get()), ((Float)p.getSecond()).floatValue()));
        FireBlock fire = (FireBlock)Blocks.FIRE;
        flamables.forEach(p -> fire.setFlammable((Block)((Supplier)p.getFirst()).get(), ((Integer)((Pair)p.getSecond()).getFirst()).intValue(), ((Integer)((Pair)p.getSecond()).getSecond()).intValue()));
    }

    public static void registerDispensers() {
        DispenserBlock.registerBehavior((ItemLike)Items.BOWL, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

            protected ItemStack execute(BlockSource bp, ItemStack is) {
                Direction d = (Direction)bp.state().getValue((Property)DispenserBlock.FACING);
                BlockPos front = bp.pos().relative(d);
                FluidState fs = bp.level().getBlockState(front).getFluidState();
                BlockEntity blockEntity = bp.level().getBlockEntity(front);
                if (blockEntity != null) {
                    IFluidHandler ip = (IFluidHandler)bp.level().getCapability(Capabilities.FluidHandler.BLOCK, front, (Object)d.getOpposite());
                    if (ip != null) {
                        ItemStack ret = CauponaApi.fillBowl(ip).orElse(null);
                        if (ret != null) {
                            if (is.getCount() == 1) {
                                return ret;
                            }
                            is.shrink(1);
                            if (!bp.blockEntity().insertItem(ret).isEmpty()) {
                                this.defaultBehaviour.dispense(bp, ret);
                            }
                        }
                    } else if (blockEntity instanceof PanBlockEntity) {
                        PanBlockEntity pan = (PanBlockEntity)blockEntity;
                        ItemStack out = pan.inv.getStackInSlot(10);
                        if (!out.isEmpty()) {
                            pan.inv.setStackInSlot(10, ItemStack.EMPTY);
                            if (!bp.blockEntity().insertItem(out).isEmpty()) {
                                this.defaultBehaviour.dispense(bp, out);
                            }
                        }
                    }
                    return is;
                }
                if (!fs.isEmpty()) {
                    ItemStack ret = CauponaApi.fillBowl(new FluidStack(fs.getType(), 250)).orElse(null);
                    if (ret != null) {
                        if (is.getCount() == 1) {
                            return ret;
                        }
                        is.shrink(1);
                        if (!bp.blockEntity().insertItem(ret).isEmpty()) {
                            this.defaultBehaviour.dispense(bp, ret);
                        }
                    }
                    return is;
                }
                return this.defaultBehaviour.dispense(bp, is);
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)CPItems.redstone_ladle.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack execute(BlockSource bp, ItemStack is) {
                Direction d = (Direction)bp.state().getValue((Property)DispenserBlock.FACING);
                BlockPos front = bp.pos().relative(d);
                BlockPos back = bp.pos().relative(d.getOpposite());
                Block src = bp.level().getBlockState(front).getBlock();
                Optional blockSource = FluidUtil.getFluidHandler((Level)bp.level(), (BlockPos)front, (Direction)d.getOpposite());
                BlockEntity besrc = bp.level().getBlockEntity(front);
                BlockEntity blockTarget = bp.level().getBlockEntity(back);
                if (blockTarget != null) {
                    block16: {
                        @Nullable IFluidHandler iptar = (IFluidHandler)bp.level().getCapability(Capabilities.FluidHandler.BLOCK, back, (Object)d);
                        if (iptar != null) {
                            if (blockSource.isPresent()) {
                                FluidUtil.tryFluidTransfer((IFluidHandler)iptar, (IFluidHandler)blockSource.orElse(null), (int)250, (boolean)true);
                            } else if (src instanceof BucketPickup) {
                                BucketPickup bpu = (BucketPickup)src;
                                FluidUtil.tryFluidTransfer((IFluidHandler)iptar, (IFluidHandler)new BucketPickupHandlerWrapper(null, bpu, (Level)bp.level(), front), (int)1000, (boolean)true);
                            } else if (besrc instanceof IFoodContainer) {
                                IFoodContainer cont = (IFoodContainer)besrc;
                                for (int i = 0; i < cont.getSlots(); ++i) {
                                    FluidStack fs;
                                    ItemStack its = cont.getInternal(i);
                                    IFluidHandlerItem ifhi = (IFluidHandlerItem)Capabilities.FluidHandler.ITEM.getCapability(its, null);
                                    if (ifhi == null || (fs = ifhi.getFluidInTank(0)).isEmpty() || iptar.fill(fs, IFluidHandler.FluidAction.SIMULATE) != fs.getAmount()) continue;
                                    iptar.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                                    cont.setInternal(i, its.getCraftingRemainingItem());
                                    break;
                                }
                            }
                        } else if (blockTarget instanceof IFoodContainer) {
                            IFluidHandler tank;
                            FluidStack fs;
                            IFoodContainer contt = (IFoodContainer)blockTarget;
                            @Nullable IFluidHandler ipsrc = (IFluidHandler)bp.level().getCapability(Capabilities.FluidHandler.BLOCK, front, (Object)d.getOpposite());
                            if (besrc instanceof IFoodContainer) {
                                IFoodContainer cont = (IFoodContainer)besrc;
                                for (int i = 0; i < cont.getSlots(); ++i) {
                                    ItemStack its = cont.getInternal(i);
                                    if (its.isEmpty() || !Utils.isExtractAllowed(its)) continue;
                                    for (int j = 0; j < contt.getSlots(); ++j) {
                                        ItemStack its2 = contt.getInternal(j);
                                        if (!Utils.isExchangeAllowed(its, its2) || !cont.accepts(i, its2) || !contt.accepts(j, its)) continue;
                                        cont.setInternal(i, its2);
                                        contt.setInternal(j, its);
                                        break block16;
                                    }
                                }
                            } else if (ipsrc != null && !(fs = (tank = ipsrc).drain(250, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
                                for (int j = 0; j < contt.getSlots(); ++j) {
                                    ContanerContainFoodEvent ev;
                                    ItemStack its2 = contt.getInternal(j);
                                    if (its2.getCount() != 1 || !(ev = Utils.contain(its2, fs, true)).isAllowed()) continue;
                                    if (!contt.accepts(j, ev.out) || (fs = tank.drain(ev.drainAmount, IFluidHandler.FluidAction.EXECUTE)).getAmount() != ev.drainAmount) break;
                                    ev = Utils.contain(its2, fs, false);
                                    contt.setInternal(j, ev.out);
                                    break;
                                }
                            }
                        }
                    }
                    return is;
                }
                return is;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)CPItems.walnut_boat.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource pSource, ItemStack pStack) {
                double d3;
                Direction direction = (Direction)pSource.state().getValue((Property)DispenserBlock.FACING);
                ServerLevel level = pSource.level();
                double d0 = (float)pSource.pos().getX() + (float)direction.getStepX() * 1.125f;
                double d1 = (float)pSource.pos().getY() + (float)direction.getStepY() * 1.125f;
                double d2 = (float)pSource.pos().getZ() + (float)direction.getStepZ() * 1.125f;
                BlockPos blockpos = pSource.pos().relative(direction);
                if (level.getFluidState(blockpos).is(FluidTags.WATER)) {
                    d3 = 1.0;
                } else {
                    if (!level.getBlockState(blockpos).isAir() || !level.getFluidState(blockpos.below()).is(FluidTags.WATER)) {
                        return this.defaultDispenseItemBehavior.dispense(pSource, pStack);
                    }
                    d3 = 0.0;
                }
                CPBoat boat = new CPBoat((Level)level, d0, d1 + d3, d2);
                boat.setYRot(direction.toYRot());
                level.addFreshEntity((Entity)boat);
                pStack.shrink(1);
                return pStack;
            }

            protected void playSound(BlockSource pSource) {
                pSource.level().levelEvent(1000, pSource.pos(), 0);
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)CPItems.gravy_boat.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

            protected ItemStack execute(BlockSource bp, ItemStack is) {
                Direction d = (Direction)bp.state().getValue((Property)DispenserBlock.FACING);
                BlockPos front = bp.pos().relative(d);
                BlockState bs = bp.level().getBlockState(front);
                if (bs.is((Block)CPBlocks.GRAVY_BOAT.get())) {
                    int idmg = is.getDamageValue();
                    is.setDamageValue(((Integer)bs.getValue((Property)GravyBoatBlock.LEVEL)).intValue());
                    bp.level().setBlockAndUpdate(front, (BlockState)bs.setValue((Property)GravyBoatBlock.LEVEL, (Comparable)Integer.valueOf(idmg)));
                    return is;
                }
                return this.defaultBehaviour.dispense(bp, is);
            }
        });
        DefaultDispenseItemBehavior idispenseitembehavior1 = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource source, ItemStack stack) {
                Direction d = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos front = source.pos().relative(d);
                @Nullable IFluidHandler ip = (IFluidHandler)source.level().getCapability(Capabilities.FluidHandler.BLOCK, front, (Object)d.getOpposite());
                if (ip != null) {
                    FluidActionResult fa = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)ip, null, (int)1250, null, (boolean)true);
                    if (fa.isSuccess()) {
                        if (fa.getResult() != null) {
                            return fa.getResult();
                        }
                        stack.shrink(1);
                    }
                    return stack;
                }
                return this.defaultBehaviour.dispense(source, stack);
            }
        };
        DispenserBlock.registerBehavior((ItemLike)Items.MILK_BUCKET, (DispenseItemBehavior)idispenseitembehavior1);
        DefaultDispenseItemBehavior ddib = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                FluidStack fs = ((IFluidHandlerItem)Capabilities.FluidHandler.ITEM.getCapability(stack, null)).getFluidInTank(0);
                Direction d = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos front = source.pos().relative(d);
                BlockEntity blockEntity = source.level().getBlockEntity(front);
                if (!fs.isEmpty()) {
                    IFluidHandler handler;
                    IFluidHandler ip;
                    if (blockEntity instanceof StewPotBlockEntity) {
                        StewPotBlockEntity pot = (StewPotBlockEntity)blockEntity;
                        if (pot.tryAddFluid(fs)) {
                            ItemStack ret = stack.getCraftingRemainingItem();
                            if (stack.getCount() == 1) {
                                return ret;
                            }
                            stack.shrink(1);
                            if (!source.blockEntity().insertItem(ret).isEmpty()) {
                                this.defaultBehaviour.dispense(source, ret);
                            }
                        }
                    } else if (blockEntity != null && (ip = (IFluidHandler)source.level().getCapability(Capabilities.FluidHandler.BLOCK, front, (Object)d.getOpposite())) != null && (handler = ip).fill(fs, IFluidHandler.FluidAction.SIMULATE) == fs.getAmount()) {
                        handler.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                        ItemStack ret = stack.getCraftingRemainingItem();
                        if (stack.getCount() == 1) {
                            return ret;
                        }
                        stack.shrink(1);
                        if (!source.blockEntity().insertItem(ret).isEmpty()) {
                            this.defaultBehaviour.dispense(source, ret);
                        }
                    }
                    return stack;
                }
                return this.defaultBehaviour.dispense(source, stack);
            }
        };
        for (Item i : CPItems.stews) {
            DispenserBlock.registerBehavior((ItemLike)i, (DispenseItemBehavior)ddib);
        }
        DefaultDispenseItemBehavior spice = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                Direction d = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos front = source.pos().relative(d);
                BlockEntity blockEntity = source.level().getBlockEntity(front);
                if (blockEntity instanceof StewPotBlockEntity) {
                    StewPotBlockEntity pot = (StewPotBlockEntity)blockEntity;
                    ItemStack ospice = pot.getInv().getStackInSlot(11);
                    pot.getInv().setStackInSlot(11, stack);
                    return ospice;
                }
                if (blockEntity instanceof PanBlockEntity) {
                    PanBlockEntity pan = (PanBlockEntity)blockEntity;
                    ItemStack ospice = ((PanBlockEntity)blockEntity).getInv().getStackInSlot(11);
                    pan.getInv().setStackInSlot(11, stack);
                    return ospice;
                }
                if (blockEntity instanceof CounterDoliumBlockEntity) {
                    CounterDoliumBlockEntity dolium = (CounterDoliumBlockEntity)blockEntity;
                    ItemStack ospice = dolium.getInv().getStackInSlot(3);
                    dolium.getInv().setStackInSlot(3, stack);
                    return ospice;
                }
                return this.defaultBehaviour.dispense(source, stack);
            }
        };
        DefaultDispenseItemBehavior pot = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                Direction d = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos front = source.pos().relative(d);
                BlockEntity blockEntity = source.level().getBlockEntity(front);
                if (blockEntity instanceof StewPotBlockEntity) {
                    StewPotBlockEntity pot = (StewPotBlockEntity)blockEntity;
                    ItemStack ospice = pot.getInv().getStackInSlot(11);
                    pot.getInv().setStackInSlot(11, ItemStack.EMPTY);
                    if (!source.blockEntity().insertItem(ospice).isEmpty()) {
                        this.defaultBehaviour.dispense(source, ospice);
                    }
                    return stack;
                }
                if (blockEntity instanceof PanBlockEntity) {
                    PanBlockEntity pan = (PanBlockEntity)blockEntity;
                    ItemStack ospice = pan.getInv().getStackInSlot(11);
                    pan.getInv().setStackInSlot(11, ItemStack.EMPTY);
                    if (!source.blockEntity().insertItem(ospice).isEmpty()) {
                        this.defaultBehaviour.dispense(source, ospice);
                    }
                    return stack;
                }
                if (blockEntity instanceof CounterDoliumBlockEntity) {
                    CounterDoliumBlockEntity dolium = (CounterDoliumBlockEntity)blockEntity;
                    ItemStack ospice = dolium.getInv().getStackInSlot(3);
                    dolium.getInv().setStackInSlot(3, ItemStack.EMPTY);
                    if (!source.blockEntity().insertItem(ospice).isEmpty()) {
                        this.defaultBehaviour.dispense(source, ospice);
                    }
                    return stack;
                }
                return this.defaultBehaviour.dispense(source, stack);
            }
        };
        DispenserBlock.registerBehavior((ItemLike)Items.FLOWER_POT, (DispenseItemBehavior)pot);
        for (DeferredHolder<Item, Item> i : CPItems.spicesItems) {
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)i.get()), (DispenseItemBehavior)spice);
        }
    }
}

