/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPCommonBootStrap;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.CPWorldGen;
import com.teammoeg.caupona.blocks.CPHorizontalBlock;
import com.teammoeg.caupona.blocks.decoration.BaseColumnBlock;
import com.teammoeg.caupona.blocks.decoration.CPButtonBlock;
import com.teammoeg.caupona.blocks.decoration.CPDoorBlock;
import com.teammoeg.caupona.blocks.decoration.CPPressurePlateBlock;
import com.teammoeg.caupona.blocks.decoration.CPRoadBlock;
import com.teammoeg.caupona.blocks.decoration.CPRoadSideBlock;
import com.teammoeg.caupona.blocks.decoration.CPStandingSignBlock;
import com.teammoeg.caupona.blocks.decoration.CPTrapDoorBlock;
import com.teammoeg.caupona.blocks.decoration.CPWallSignBlock;
import com.teammoeg.caupona.blocks.decoration.ChimneyFluteBlock;
import com.teammoeg.caupona.blocks.decoration.ColumnCapitalBlock;
import com.teammoeg.caupona.blocks.decoration.LacunarBlock;
import com.teammoeg.caupona.blocks.decoration.SpokedFenceBlock;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicBlock;
import com.teammoeg.caupona.blocks.decoration.mosaic.MosaicItem;
import com.teammoeg.caupona.blocks.decoration.mosaic.TessellationWorkBenchBlock;
import com.teammoeg.caupona.blocks.dolium.CounterDoliumBlock;
import com.teammoeg.caupona.blocks.foods.BowlBlock;
import com.teammoeg.caupona.blocks.foods.DishBlock;
import com.teammoeg.caupona.blocks.fumarole.FumaroleBoulderBlock;
import com.teammoeg.caupona.blocks.fumarole.FumaroleVentBlock;
import com.teammoeg.caupona.blocks.fumarole.PumiceBloomBlock;
import com.teammoeg.caupona.blocks.hypocaust.CaliductBlock;
import com.teammoeg.caupona.blocks.hypocaust.FireboxBlock;
import com.teammoeg.caupona.blocks.hypocaust.WolfStatueBlock;
import com.teammoeg.caupona.blocks.pan.GravyBoatBlock;
import com.teammoeg.caupona.blocks.pan.PanBlock;
import com.teammoeg.caupona.blocks.plants.BushLogBlock;
import com.teammoeg.caupona.blocks.plants.CPStripPillerBlock;
import com.teammoeg.caupona.blocks.plants.FruitBlock;
import com.teammoeg.caupona.blocks.plants.FruitsLeavesBlock;
import com.teammoeg.caupona.blocks.plants.SilphiumBlock;
import com.teammoeg.caupona.blocks.plants.SnailBaitBlock;
import com.teammoeg.caupona.blocks.plants.SnailBlock;
import com.teammoeg.caupona.blocks.plants.WalnutFruitBlock;
import com.teammoeg.caupona.blocks.pot.StewPot;
import com.teammoeg.caupona.blocks.stove.ChimneyPotBlock;
import com.teammoeg.caupona.blocks.stove.KitchenStove;
import com.teammoeg.caupona.blocks.stove.KitchenStoveBlockEntity;
import com.teammoeg.caupona.item.CPBlockItem;
import com.teammoeg.caupona.item.CPSignItem;
import com.teammoeg.caupona.item.DishItem;
import com.teammoeg.caupona.util.MaterialType;
import com.teammoeg.caupona.util.TabType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CPBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"caupona");
    public static final String[] woods = new String[]{"walnut"};
    public static final MaterialType[] all_materials = new MaterialType[]{new MaterialType("mud").makeCounter(1), new MaterialType("stone_brick").makeCounter(2).makeHypocaust(), new MaterialType("stone").setBase(() -> Blocks.STONE.defaultBlockState()).makePillar().makeRoad(), new MaterialType("sandstone").setBase(() -> Blocks.SANDSTONE.defaultBlockState()).makeRoad(), new MaterialType("brick").makeCounter(2).makeHypocaust(), new MaterialType("mixed_bricks").makeDecoration(), new MaterialType("opus_incertum").makeCounter(2).makeDecoration().makeHypocaust(), new MaterialType("opus_latericium").makeCounter(2).makeDecoration().makeHypocaust(), new MaterialType("opus_reticulatum").makeDecoration(), new MaterialType("felsic_tuff_bricks").makeDecoration(), new MaterialType("felsic_tuff").makeDecoration().makePillar().makeRoad(), new MaterialType("polished_felsic_tuff").makeDecoration(), new MaterialType("quartz").makePillar(), new MaterialType("calcite").makePillar()};
    public static final List<DeferredHolder<Block, KitchenStove>> stoves = new ArrayList<DeferredHolder<Block, KitchenStove>>();
    public static final List<Block> signs = new ArrayList<Block>();
    public static final Map<String, DeferredHolder<Block, Block>> stoneBlocks = new HashMap<String, DeferredHolder<Block, Block>>();
    public static final List<Block> chimney = new ArrayList<Block>();
    public static final List<Block> dolium = new ArrayList<Block>();
    public static final List<Block> dishes = new ArrayList<Block>();
    public static final List<Block> caliduct = new ArrayList<Block>();
    public static final List<Block> firebox = new ArrayList<Block>();
    public static final List<DeferredHolder<Block, Block>> leaves = new ArrayList<DeferredHolder<Block, Block>>();
    public static final DeferredHolder<Block, FumaroleBoulderBlock> FUMAROLE_BOULDER = CPBlocks.decoblock("fumarole_boulder", () -> new FumaroleBoulderBlock(CPBlocks.getStoneProps().isViewBlocking(CPBlocks::isntSolid).noOcclusion().isSuffocating(CPBlocks::isntSolid)));
    public static final DeferredHolder<Block, FumaroleVentBlock> FUMAROLE_VENT = CPBlocks.maindecoblock("fumarole_vent", () -> new FumaroleVentBlock(CPBlocks.getStoneProps().strength(4.5f, 10.0f).isViewBlocking(CPBlocks::isntSolid).noOcclusion().isSuffocating(CPBlocks::isntSolid)));
    public static final DeferredHolder<Block, Block> PUMICE = CPBlocks.block("pumice", CPBlocks.getStoneProps(), TabType.DECORATION);
    public static final DeferredHolder<Block, PumiceBloomBlock> PUMICE_BLOOM = CPBlocks.maindecoblock("pumice_bloom", () -> new PumiceBloomBlock(CPBlocks.getStoneProps().noOcclusion()));
    public static final DeferredHolder<Block, GravyBoatBlock> GRAVY_BOAT = BLOCKS.register("gravy_boat", () -> new GravyBoatBlock(BlockBehaviour.Properties.of().sound(SoundType.GLASS).instabreak().noOcclusion().isSuffocating(CPBlocks::isntSolid).isViewBlocking(CPBlocks::isntSolid)));
    public static final BlockSetType WALNUT_TYPE = new BlockSetType("walnut");
    public static final WoodType WALNUT = WoodType.register((WoodType)new WoodType("caupona:walnut", WALNUT_TYPE));
    public static final DeferredHolder<Block, WolfStatueBlock> WOLF = CPBlocks.maindecoblock("wolf_statue", () -> new WolfStatueBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.COPPER).requiresCorrectToolForDrops().strength(3.5f, 10.0f).noOcclusion()));
    public static final DeferredHolder<Block, PanBlock> STONE_PAN = CPBlocks.mainblock("stone_griddle", () -> new PanBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(3.5f, 10.0f).noOcclusion()));
    public static final DeferredHolder<Block, TessellationWorkBenchBlock> T_BENCH = CPBlocks.mainblock("tessellation_workbench", () -> new TessellationWorkBenchBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).sound(SoundType.STONE).strength(3.5f, 10.0f).noOcclusion().requiresCorrectToolForDrops()));
    public static final DeferredHolder<Block, PanBlock> COPPER_PAN = CPBlocks.mainblock("copper_frying_pan", () -> new PanBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.COPPER).strength(3.5f, 10.0f).noOcclusion()));
    public static final DeferredHolder<Block, PanBlock> IRON_PAN = CPBlocks.mainblock("iron_frying_pan", () -> new PanBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.5f, 10.0f).noOcclusion()));
    public static final DeferredHolder<Block, PanBlock> LEAD_PAN = CPBlocks.mainblock("lead_frying_pan", () -> new PanBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.5f, 10.0f).noOcclusion()));
    public static final DeferredHolder<Block, DishBlock> DISH = BLOCKS.register("dish", () -> new DishBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).instabreak().noOcclusion().isRedstoneConductor(CPBlocks::isntSolid).isSuffocating(CPBlocks::isntSolid).isViewBlocking(CPBlocks::isntSolid)));
    public static final DeferredHolder<Block, StewPot> STEW_POT = CPBlocks.mainblock("stew_pot", () -> new StewPot(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).sound(SoundType.STONE).requiresCorrectToolForDrops().strength(3.5f, 10.0f).noOcclusion(), CPBlockEntityTypes.STEW_POT));
    public static final DeferredHolder<Block, StewPot> STEW_POT_LEAD = CPBlocks.mainblock("lead_stew_pot", () -> new StewPot(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).sound(SoundType.STONE).requiresCorrectToolForDrops().strength(3.5f, 10.0f).noOcclusion(), CPBlockEntityTypes.STEW_POT));
    public static final DeferredHolder<Block, BowlBlock> BOWL = BLOCKS.register("bowl", () -> new BowlBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).instabreak().noOcclusion().isRedstoneConductor(CPBlocks::isntSolid).isSuffocating(CPBlocks::isntSolid).isViewBlocking(CPBlocks::isntSolid), CPBlockEntityTypes.BOWL));
    public static final DeferredHolder<Block, MosaicBlock> MOSAIC = CPBlocks.baseblock("mosaic", () -> new MosaicBlock(CPBlocks.getStoneProps()), b -> new MosaicItem(CPItems.createProps()));
    public static final DeferredHolder<Block, SilphiumBlock> SILPHIUM = CPBlocks.mainblock("silphium_block", () -> new SilphiumBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).replaceable().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY)));
    public static final DeferredHolder<Block, Block> WALNUT_FRUIT = CPBlocks.mainblock("walnut_fruits", () -> new WalnutFruitBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().offsetType(BlockBehaviour.OffsetType.XZ).instabreak().sound(SoundType.CROP).ignitedByLava()));
    public static final DeferredHolder<Block, Block> SNAIL_MUCUS = CPBlocks.block("snail_mucus", BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().instabreak().sound(SoundType.CROP).noOcclusion().isViewBlocking(CPBlocks::isntSolid), TabType.MAIN_AND_DECORATION);
    public static final DeferredHolder<Block, SnailBlock> SNAIL = CPBlocks.baseblock("snail_block", () -> new SnailBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().offsetType(BlockBehaviour.OffsetType.XZ).instabreak().sound(SoundType.CROP).isViewBlocking(CPBlocks::isntSolid)), x -> new CPBlockItem((Block)x, CPItems.createProps(), TabType.MAIN));
    public static final DeferredHolder<Block, SnailBaitBlock> SNAIL_BAIT = CPBlocks.baseblock("snail_bait", () -> new SnailBaitBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().offsetType(BlockBehaviour.OffsetType.XZ).instabreak().sound(SoundType.CROP).isViewBlocking(CPBlocks::isntSolid)), x -> new CPBlockItem((Block)x, CPItems.createProps(), TabType.MAIN));
    public static final DeferredHolder<Block, Block> LEAD_BLOCK = CPBlocks.block("lead_block", BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.5f, 10.0f).requiresCorrectToolForDrops(), TabType.DECORATION);

    private static void registerBush(String wood, Supplier<TreeGrower> growth) {
        CPBlocks.decoblock(wood + "_log", () -> new BushLogBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f).noOcclusion().sound(SoundType.WOOD)));
        DeferredHolder<Block, Block> a = CPBlocks.decoblock(wood + "_fruits", () -> new FruitBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).offsetType(BlockBehaviour.OffsetType.XZ).noCollission().randomTicks().instabreak().sound(SoundType.CROP)));
        leaves.add(CPCommonBootStrap.asCompositable(CPBlocks.decoblock(wood + "_leaves", () -> CPBlocks.leaves(SoundType.GRASS, a)), 0.3f));
        CPCommonBootStrap.asCompositable(CPBlocks.maindecoblock(wood + "_sapling", () -> new SaplingBlock((TreeGrower)growth.get(), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.GRASS))), 0.3f);
    }

    private static void registerWood(String wood, WoodType wt, Supplier<TreeGrower> growth, DeferredHolder<Block, Block> f) {
        DeferredHolder<Block, Block> planks = CPCommonBootStrap.asFlamable(CPBlocks.block(wood + "_planks", BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava(), TabType.DECORATION), 5, 20);
        CPBlocks.decoblock(wood + "_button", () -> new CPButtonBlock(BlockBehaviour.Properties.of().noCollission().strength(0.5f).sound(SoundType.WOOD).ignitedByLava(), WALNUT_TYPE, 30));
        CPBlocks.decoblock(wood + "_door", () -> new CPDoorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(3.0f).sound(SoundType.WOOD).noOcclusion().ignitedByLava(), WALNUT_TYPE));
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava())), 5, 20);
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_fence_gate", () -> new FenceGateBlock(WALNUT, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava())), 5, 20);
        leaves.add(CPCommonBootStrap.asCompositable(CPBlocks.decoblock(wood + "_leaves", () -> CPBlocks.leaves(SoundType.GRASS, f)), 0.3f));
        DeferredHolder<Block, Block> sl = CPCommonBootStrap.asFlamable(CPBlocks.decoblock("stripped_" + wood + "_log", () -> CPBlocks.log(null)), 5, 5);
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_log", () -> CPBlocks.log(sl)), 5, 5);
        CPBlocks.decoblock(wood + "_pressure_plate", () -> new CPPressurePlateBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).noCollission().strength(0.5f).sound(SoundType.WOOD).ignitedByLava(), WALNUT_TYPE));
        CPCommonBootStrap.asCompositable(CPBlocks.maindecoblock(wood + "_sapling", () -> new SaplingBlock((TreeGrower)growth.get(), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().instabreak().sound(SoundType.GRASS).ignitedByLava())), 0.3f);
        DeferredHolder s = BLOCKS.register(wood + "_sign", () -> new CPStandingSignBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).noCollission().strength(1.0f).sound(SoundType.WOOD).ignitedByLava(), wt));
        DeferredHolder ws = BLOCKS.register(wood + "_wall_sign", () -> new CPWallSignBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).noCollission().strength(1.0f).sound(SoundType.WOOD).ignitedByLava(), wt));
        CPItems.ITEMS.register(wood + "_sign", () -> new CPSignItem(new Item.Properties().stacksTo(16), (Block)s.get(), (Block)ws.get(), TabType.DECORATION));
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava())), 5, 20);
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_stairs", () -> new StairBlock(((Block)planks.get()).defaultBlockState(), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f, 3.0f).sound(SoundType.WOOD))), 5, 20);
        CPBlocks.decoblock(wood + "_trapdoor", () -> new CPTrapDoorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(3.0f).sound(SoundType.WOOD).noOcclusion().isValidSpawn(CPBlocks::never).ignitedByLava(), WALNUT_TYPE));
        DeferredHolder<Block, Block> sw = CPCommonBootStrap.asFlamable(CPBlocks.decoblock("stripped_" + wood + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f).sound(SoundType.WOOD).ignitedByLava())), 5, 5);
        CPCommonBootStrap.asFlamable(CPBlocks.decoblock(wood + "_wood", () -> new CPStripPillerBlock(sw, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f).sound(SoundType.WOOD).ignitedByLava())), 5, 5);
    }

    static DeferredHolder<Block, KitchenStove> stove(String name, BlockBehaviour.Properties props, DeferredHolder<BlockEntityType<?>, BlockEntityType<KitchenStoveBlockEntity>> tile) {
        DeferredHolder bl = BLOCKS.register(name, () -> new KitchenStove(props, tile));
        stoves.add((DeferredHolder<Block, KitchenStove>)bl);
        CPItems.ITEMS.register(name, () -> new CPBlockItem((Block)bl.get(), CPItems.createProps(), TabType.MAIN_AND_DECORATION));
        return bl;
    }

    static <T extends Block> DeferredHolder<Block, T> mainblock(String name, Supplier<T> bl) {
        DeferredHolder blx = BLOCKS.register(name, bl);
        CPItems.ITEMS.register(name, () -> new CPBlockItem((Block)blx.get(), CPItems.createProps(), TabType.MAIN));
        return blx;
    }

    static <T extends Block> DeferredHolder<Block, T> decoblock(String name, Supplier<T> bl) {
        DeferredHolder blx = BLOCKS.register(name, bl);
        CPItems.ITEMS.register(name, () -> new CPBlockItem((Block)blx.get(), CPItems.createProps(), TabType.DECORATION));
        return blx;
    }

    static <T extends Block> DeferredHolder<Block, T> maindecoblock(String name, Supplier<T> bl) {
        DeferredHolder blx = BLOCKS.register(name, bl);
        CPItems.ITEMS.register(name, () -> new CPBlockItem((Block)blx.get(), CPItems.createProps(), TabType.MAIN_AND_DECORATION));
        return blx;
    }

    static <T extends Block> DeferredHolder<Block, T> baseblock(String name, Supplier<T> bl, Function<T, Item> toitem) {
        DeferredHolder blx = BLOCKS.register(name, bl);
        CPItems.ITEMS.register(name, () -> (Item)toitem.apply((Block)blx.get()));
        return blx;
    }

    static DeferredHolder<Block, Block> block(String name, BlockBehaviour.Properties props, TabType tab) {
        DeferredHolder blx = BLOCKS.register(name, () -> new Block(props));
        CPItems.ITEMS.register(name, () -> new CPBlockItem((Block)blx.get(), CPItems.createProps(), tab));
        return blx;
    }

    private static LeavesBlock leaves(SoundType p_152615_, DeferredHolder<Block, Block> fruit) {
        return new FruitsLeavesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(p_152615_).noOcclusion().isValidSpawn(CPBlocks::ocelotOrParrot).isSuffocating(CPBlocks::isntSolid).isViewBlocking(CPBlocks::isntSolid).ignitedByLava(), fruit);
    }

    private static RotatedPillarBlock log(DeferredHolder<Block, Block> st) {
        if (st == null) {
            return new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
        }
        return new CPStripPillerBlock(st, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    }

    private static BlockBehaviour.Properties getStoneProps() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).requiresCorrectToolForDrops().strength(2.0f, 6.0f);
    }

    private static BlockBehaviour.Properties getStoveProps() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).requiresCorrectToolForDrops().strength(3.5f, 10.0f).noOcclusion().lightLevel(s -> (Boolean)s.getValue((Property)KitchenStove.LIT) != false ? 9 : 0).isRedstoneConductor(CPBlocks::isntSolid).isSuffocating(CPBlocks::isntSolid);
    }

    private static BlockBehaviour.Properties getTransparentProps() {
        return BlockBehaviour.Properties.of().sound(SoundType.STONE).requiresCorrectToolForDrops().strength(3.5f, 10.0f).noOcclusion();
    }

    private static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    private static Boolean never(BlockState p_50779_, BlockGetter p_50780_, BlockPos p_50781_, EntityType<?> p_50782_) {
        return false;
    }

    private static Boolean ocelotOrParrot(BlockState p_50822_, BlockGetter p_50823_, BlockPos p_50824_, EntityType<?> p_50825_) {
        return p_50825_ == EntityType.OCELOT || p_50825_ == EntityType.PARROT;
    }

    static {
        for (MaterialType type : all_materials) {
            String name = type.getName();
            if (type.isDecorationMaterial()) {
                DeferredHolder<Block, Block> base = CPBlocks.block(name, CPBlocks.getStoneProps(), TabType.DECORATION);
                stoneBlocks.put(name, base);
                type.setBase(() -> ((Block)base.get()).defaultBlockState());
                CPBlocks.decoblock(name + "_slab", () -> new SlabBlock(CPBlocks.getStoneProps()));
                CPBlocks.decoblock(name + "_stairs", () -> new StairBlock(type.getBase().get(), CPBlocks.getStoneProps()));
                CPBlocks.decoblock(name + "_wall", () -> new WallBlock(CPBlocks.getStoneProps()));
            }
            if (type.isCounterMaterial()) {
                CPBlocks.stove(name + "_kitchen_stove", CPBlocks.getStoveProps(), type.getCounterGrade() == 1 ? CPBlockEntityTypes.STOVE_T1 : CPBlockEntityTypes.STOVE_T2);
                CPBlocks.maindecoblock(name + "_chimney_flue", () -> new ChimneyFluteBlock(CPBlocks.getTransparentProps()));
                CPBlocks.maindecoblock(name + "_chimney_pot", () -> new ChimneyPotBlock(CPBlocks.getTransparentProps()));
                CPBlocks.decoblock(name + "_counter", () -> new CPHorizontalBlock(CPBlocks.getStoneProps()));
                CPBlocks.maindecoblock(name + "_counter_with_dolium", () -> new CounterDoliumBlock(CPBlocks.getTransparentProps()));
            }
            if (type.isHypocaustMaterial()) {
                CPBlocks.mainblock(name + "_caliduct", () -> new CaliductBlock(CPBlocks.getTransparentProps()));
                CPBlocks.mainblock(name + "_hypocaust_firebox", () -> new FireboxBlock(CPBlocks.getTransparentProps()));
            }
            if (type.isPillarMaterial()) {
                CPBlocks.decoblock(name + "_column_fluted_plinth", () -> new BaseColumnBlock(CPBlocks.getTransparentProps().strength(2.0f, 6.0f), true));
                CPBlocks.decoblock(name + "_column_fluted_shaft", () -> new BaseColumnBlock(CPBlocks.getTransparentProps().strength(2.0f, 6.0f), false));
                CPBlocks.decoblock(name + "_column_shaft", () -> new BaseColumnBlock(CPBlocks.getTransparentProps().strength(2.0f, 6.0f), false));
                CPBlocks.decoblock(name + "_column_plinth", () -> new BaseColumnBlock(CPBlocks.getTransparentProps().strength(2.0f, 6.0f), true));
                CPBlocks.decoblock(name + "_ionic_column_capital", () -> new ColumnCapitalBlock(CPBlocks.getTransparentProps().strength(2.0f, 6.0f), true));
                CPBlocks.decoblock(name + "_tuscan_column_capital", () -> new ColumnCapitalBlock(CPBlocks.getTransparentProps().strength(2.0f, 6.0f), false));
                CPBlocks.decoblock(name + "_acanthine_column_capital", () -> new ColumnCapitalBlock(CPBlocks.getTransparentProps().strength(2.0f, 6.0f), true));
                CPBlocks.decoblock(name + "_lacunar_tile", () -> new LacunarBlock(CPBlocks.getTransparentProps().strength(2.0f, 6.0f).isViewBlocking(CPBlocks::isntSolid)));
                CPBlocks.decoblock(name + "_spoked_fence", () -> new SpokedFenceBlock(CPBlocks.getTransparentProps().strength(2.0f, 6.0f)));
            }
            if (!type.isRoadMaterial()) continue;
            CPBlocks.decoblock(name + "_road_side", () -> new CPRoadSideBlock(CPBlocks.getTransparentProps().isRedstoneConductor(CPBlocks::isntSolid).isSuffocating(CPBlocks::isntSolid).strength(2.0f, 6.0f)));
            CPBlocks.decoblock(name + "_road", () -> new CPRoadBlock(CPBlocks.getTransparentProps().isRedstoneConductor(CPBlocks::isntSolid).isSuffocating(CPBlocks::isntSolid).strength(2.0f, 6.0f)));
        }
        CPBlocks.registerWood("walnut", WALNUT, () -> new TreeGrower("walnut", Optional.empty(), Optional.of(CPWorldGen.WALNUT), Optional.empty()), WALNUT_FRUIT);
        CPBlocks.registerBush("fig", () -> new TreeGrower("fig", Optional.empty(), Optional.of(CPWorldGen.FIG), Optional.empty()));
        CPBlocks.registerBush("wolfberry", () -> new TreeGrower("wolfberry", Optional.empty(), Optional.of(CPWorldGen.WOLFBERRY), Optional.empty()));
        for (String s : CPItems.dishes) {
            CPBlocks.baseblock(s, () -> new DishBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).instabreak().noOcclusion().isRedstoneConductor(CPBlocks::isntSolid).isSuffocating(CPBlocks::isntSolid).isViewBlocking(CPBlocks::isntSolid)), b -> new DishItem((DishBlock)b, CPItems.createSoupProps()));
        }
    }
}

