/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api.type.capability;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.platform.Services;

public interface ICurio {
    public ItemStack getStack();

    default public void curioTick(SlotContext slotContext) {
    }

    default public void onEquip(SlotContext slotContext, ItemStack prevStack) {
    }

    default public void onUnequip(SlotContext slotContext, ItemStack newStack) {
    }

    default public boolean canEquip(SlotContext slotContext) {
        return true;
    }

    default public boolean canUnequip(SlotContext slotContext) {
        return true;
    }

    default public List<Component> getSlotsTooltip(List<Component> tooltips) {
        return tooltips;
    }

    default public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id) {
        return LinkedHashMultimap.create();
    }

    default public void onEquipFromUse(SlotContext slotContext) {
        LivingEntity entity = slotContext.entity();
        SoundInfo soundInfo = this.getEquipSound(new SlotContext("", entity, 0, false, true));
        entity.level().playSound(null, entity.blockPosition(), soundInfo.soundEvent(), entity.getSoundSource(), soundInfo.volume(), soundInfo.pitch());
    }

    @Nonnull
    default public SoundInfo getEquipSound(SlotContext slotContext) {
        return new SoundInfo((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), 1.0f, 1.0f);
    }

    default public boolean canEquipFromUse(SlotContext slotContext) {
        return false;
    }

    default public void curioBreak(SlotContext slotContext) {
        ICurio.playBreakAnimation(this.getStack(), slotContext.entity());
    }

    default public boolean canSync(SlotContext slotContext) {
        return false;
    }

    @Nonnull
    default public CompoundTag writeSyncData(SlotContext slotContext) {
        return new CompoundTag();
    }

    default public void readSyncData(SlotContext slotContext, CompoundTag compound) {
    }

    @Nonnull
    default public DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit) {
        return DropRule.DEFAULT;
    }

    default public List<Component> getAttributesTooltip(List<Component> tooltips) {
        return new ArrayList<Component>();
    }

    default public int getFortuneLevel(SlotContext slotContext, @Nullable LootContext lootContext) {
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)slotContext.entity().level().holderLookup(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE), (ItemStack)this.getStack());
    }

    default public int getLootingLevel(SlotContext slotContext, @Nullable LootContext lootContext) {
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)slotContext.entity().level().holderLookup(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOOTING), (ItemStack)this.getStack());
    }

    default public boolean makesPiglinsNeutral(SlotContext slotContext) {
        return Services.CURIOS.makesPiglinsNeutral(this.getStack(), slotContext.entity());
    }

    default public boolean canWalkOnPowderedSnow(SlotContext slotContext) {
        return Services.CURIOS.canWalkOnPowderedSnow(this.getStack(), slotContext.entity());
    }

    default public boolean isEnderMask(SlotContext slotContext, EnderMan enderMan) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return Services.CURIOS.isEnderMask(this.getStack(), player, enderMan);
        }
        return false;
    }

    public static void playBreakAnimation(ItemStack stack, LivingEntity livingEntity) {
        if (!stack.isEmpty()) {
            if (!livingEntity.isSilent()) {
                livingEntity.level().playLocalSound(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.ITEM_BREAK, livingEntity.getSoundSource(), 0.8f, 0.8f + livingEntity.level().random.nextFloat() * 0.4f, false);
            }
            for (int i = 0; i < 5; ++i) {
                Vec3 vec3d = new Vec3(((double)livingEntity.getRandom().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3d = vec3d.xRot(-livingEntity.getXRot() * ((float)Math.PI / 180));
                vec3d = vec3d.yRot(-livingEntity.getYRot() * ((float)Math.PI / 180));
                double d0 = (double)(-livingEntity.getRandom().nextFloat()) * 0.6 - 0.3;
                Vec3 vec3d1 = new Vec3(((double)livingEntity.getRandom().nextFloat() - 0.5) * 0.3, d0, 0.6);
                vec3d1 = vec3d1.xRot(-livingEntity.getXRot() * ((float)Math.PI / 180));
                vec3d1 = vec3d1.yRot(-livingEntity.getYRot() * ((float)Math.PI / 180));
                vec3d1 = vec3d1.add(livingEntity.getX(), livingEntity.getY() + (double)livingEntity.getEyeHeight(), livingEntity.getZ());
                livingEntity.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), vec3d1.x, vec3d1.y, vec3d1.z, vec3d.x, vec3d.y + 0.05, vec3d.z);
            }
        }
    }

    public record SoundInfo(SoundEvent soundEvent, float volume, float pitch) {
    }

    public static enum DropRule {
        DEFAULT,
        ALWAYS_DROP,
        ALWAYS_KEEP,
        DESTROY;

    }
}

