/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import com.mojang.serialization.MapCodec;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.TectonicResourceCondition;
import dev.worldgen.tectonic.worldgen.ConfigDensityFunction;
import dev.worldgen.tectonic.worldgen.ErosionNoiseDensityFunction;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="tectonic")
public class TectonicNeoforge {
    public static final DeferredRegister<MapCodec<? extends ICondition>> CONDITION_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)"tectonic");
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<TectonicResourceCondition>> TECTONIC = CONDITION_TYPES.register("config", () -> TectonicResourceCondition.CODEC);

    public TectonicNeoforge(IEventBus modEventBus) {
        Tectonic.init(FMLPaths.CONFIGDIR.get().resolve("tectonic.json"));
        CONDITION_TYPES.register(modEventBus);
        modEventBus.addListener(this::registerDensityFunctionTypes);
        modEventBus.addListener(this::registerEnabledPacks);
    }

    private void registerDensityFunctionTypes(RegisterEvent event) {
        event.register(Registries.DENSITY_FUNCTION_TYPE, helper -> {
            helper.register(Tectonic.id("config"), (Object)ConfigDensityFunction.CODEC_HOLDER.codec());
            helper.register(Tectonic.id("erosion_noise"), (Object)ErosionNoiseDensityFunction.CODEC_HOLDER.codec());
        });
    }

    private void registerEnabledPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path resourcePath = ModList.get().getModFileById("tectonic").getFile().findResource(new String[]{"resourcepacks/tectonic"});
            Pack dataPack = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo(resourcePath.getFileName().toString(), (Component)Component.literal((String)"Tectonic"), PackSource.BUILT_IN, Optional.empty()), (Pack.ResourcesSupplier)new PathPackResources.PathResourcesSupplier(resourcePath), (PackType)PackType.SERVER_DATA, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false));
            event.addRepositorySource(packConsumer -> packConsumer.accept(dataPack));
        }
    }
}

