/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.neoforged.neoforge.common.conditions.ICondition;

public record OverlayConditionsMetadata(List<Entry> overlays) {
    public static final Codec<OverlayConditionsMetadata> CODEC = Entry.CODEC.listOf().fieldOf("entries").xmap(OverlayConditionsMetadata::new, OverlayConditionsMetadata::overlays).codec();
    public static final MetadataSectionType<OverlayConditionsMetadata> SERIALIZER = MetadataSectionType.fromCodec((String)"neoforge:overlays", CODEC);

    public List<String> appliedOverlays() {
        ArrayList<String> appliedOverlays = new ArrayList<String>();
        for (Entry entry : this.overlays()) {
            if (!entry.condition().test(ICondition.IContext.TAGS_INVALID)) continue;
            appliedOverlays.add(entry.directory());
        }
        return appliedOverlays;
    }

    public record Entry(String directory, ICondition condition) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.validate(Entry::validateDirectory).fieldOf("directory").forGetter(Entry::directory), (App)ICondition.CODEC.fieldOf("condition").forGetter(Entry::condition)).apply((Applicative)instance, Entry::new));
        private static final Pattern DIRECTORY_NAME_PATTERN = Pattern.compile("[-_a-zA-Z0-9.]+");

        private static DataResult<String> validateDirectory(String directory) {
            boolean valid = DIRECTORY_NAME_PATTERN.matcher(directory).matches();
            return valid ? DataResult.success((Object)directory) : DataResult.error(() -> "Directory name is invalid");
        }
    }
}

