/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.item;

import com.autovw.advancednetherite.AdvancedNetherite;
import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.common.AdvancedUtil;
import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.util.ModToolTiers;
import com.autovw.advancednetherite.core.util.ModTooltips;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedSwordItem
extends SwordItem {
    private final Tier tier;

    public AdvancedSwordItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
        this.tier = tier;
    }

    public AdvancedSwordItem(Tier tier, int attackDamage, float attackSpeed) {
        this(tier, new Item.Properties().attributes(AdvancedSwordItem.createAttributes((Tier)tier, (int)attackDamage, (float)attackSpeed)).fireResistant());
    }

    public void addTooltips(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag flag) {
    }

    public ChatFormatting customDurabilityBarColor(ItemStack stack) {
        return null;
    }

    @Internal
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (ConfigHelper.get().getClient().showTooltips()) {
            if (AdvancedNetherite.getRegistryHelper().getItemById(stack.getItem()).getNamespace().equals("advancednetherite") && ConfigHelper.get().getCommon().getAdditionalDrops().enableAdditionalMobDrops()) {
                if (Screen.hasShiftDown()) {
                    if (this.tier == ModToolTiers.NETHERITE_IRON) {
                        tooltip.add((Component)ModTooltips.PHANTOM_MOB_DROP_TOOLTIP);
                    }
                    if (this.tier == ModToolTiers.NETHERITE_GOLD) {
                        tooltip.add((Component)ModTooltips.PIGLIN_MOB_DROP_TOOLTIP);
                        tooltip.add((Component)ModTooltips.ZOMBIFIED_PIGLIN_MOB_DROP_TOOLTIP);
                    }
                    if (this.tier == ModToolTiers.NETHERITE_EMERALD) {
                        tooltip.add((Component)ModTooltips.ENDERMAN_MOB_DROP_TOOLTIP);
                    }
                    if (this.tier == ModToolTiers.NETHERITE_DIAMOND) {
                        tooltip.add((Component)ModTooltips.PIGLIN_MOB_DROP_TOOLTIP);
                        tooltip.add((Component)ModTooltips.ZOMBIFIED_PIGLIN_MOB_DROP_TOOLTIP);
                        tooltip.add((Component)ModTooltips.ENDERMAN_MOB_DROP_TOOLTIP);
                    }
                } else {
                    tooltip.add((Component)ModTooltips.SHIFT_KEY_TOOLTIP);
                }
            }
            this.addTooltips(stack, context, tooltip, flag);
        }
    }

    @Internal
    public int getBarColor(ItemStack stack) {
        int originalColor = super.getBarColor(stack);
        if (this.customDurabilityBarColor(stack) != null && ConfigHelper.get().getClient().matchingDurabilityBars()) {
            return Objects.requireNonNull(this.customDurabilityBarColor(stack).getColor());
        }
        return AdvancedUtil.getDurabilityBarColor(originalColor, stack);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        float originalSpeed = super.getDestroySpeed(stack, state);
        return AdvancedUtil.getDestroySpeed(originalSpeed, stack, state);
    }
}

