/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.item;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.common.AdvancedUtil;
import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.util.ModArmorMaterials;
import com.autovw.advancednetherite.core.util.ModTooltips;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class AdvancedArmorItem
extends ArmorItem {
    private final Holder<ArmorMaterial> material;

    public AdvancedArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type armorType, Item.Properties properties) {
        super(material, armorType, properties);
        this.material = material;
    }

    @Internal
    public AdvancedArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type armorType) {
        this(material, armorType, new Item.Properties().durability(armorType.getDurability(AdvancedUtil.getArmorDurabilityMultiplier(material))).fireResistant());
    }

    public boolean pacifiesEndermen() {
        if (this.material == ModArmorMaterials.NETHERITE_IRON) {
            return ConfigHelper.get().getCommon().getArmor().isIronEndermanPassiveArmor();
        }
        if (this.material == ModArmorMaterials.NETHERITE_GOLD) {
            return ConfigHelper.get().getCommon().getArmor().isGoldEndermanPassiveArmor();
        }
        if (this.material == ModArmorMaterials.NETHERITE_EMERALD) {
            return ConfigHelper.get().getCommon().getArmor().isEmeraldEndermanPassiveArmor();
        }
        if (this.material == ModArmorMaterials.NETHERITE_DIAMOND) {
            return ConfigHelper.get().getCommon().getArmor().isDiamondEndermanPassiveArmor();
        }
        return false;
    }

    public boolean pacifiesPiglins() {
        if (this.material == ModArmorMaterials.NETHERITE_IRON) {
            return ConfigHelper.get().getCommon().getArmor().isIronPiglinPassiveArmor();
        }
        if (this.material == ModArmorMaterials.NETHERITE_GOLD) {
            return ConfigHelper.get().getCommon().getArmor().isGoldPiglinPassiveArmor();
        }
        if (this.material == ModArmorMaterials.NETHERITE_EMERALD) {
            return ConfigHelper.get().getCommon().getArmor().isEmeraldPiglinPassiveArmor();
        }
        if (this.material == ModArmorMaterials.NETHERITE_DIAMOND) {
            return ConfigHelper.get().getCommon().getArmor().isDiamondPiglinPassiveArmor();
        }
        return false;
    }

    public boolean pacifiesPhantoms() {
        if (this.material == ModArmorMaterials.NETHERITE_IRON) {
            return ConfigHelper.get().getCommon().getArmor().isIronPhantomPassiveArmor();
        }
        if (this.material == ModArmorMaterials.NETHERITE_GOLD) {
            return ConfigHelper.get().getCommon().getArmor().isGoldPhantomPassiveArmor();
        }
        if (this.material == ModArmorMaterials.NETHERITE_EMERALD) {
            return ConfigHelper.get().getCommon().getArmor().isEmeraldPhantomPassiveArmor();
        }
        if (this.material == ModArmorMaterials.NETHERITE_DIAMOND) {
            return ConfigHelper.get().getCommon().getArmor().isDiamondPhantomPassiveArmor();
        }
        return false;
    }

    public void addTooltips(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag flag) {
    }

    public ChatFormatting customDurabilityBarColor(ItemStack stack) {
        return null;
    }

    @Internal
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (ConfigHelper.get().getClient().showTooltips()) {
            if (Screen.hasShiftDown()) {
                if (this.pacifiesEndermen()) {
                    tooltip.add((Component)ModTooltips.ENDERMAN_PASSIVE_TOOLTIP);
                }
                if (this.pacifiesPiglins()) {
                    tooltip.add((Component)ModTooltips.PIGLIN_PASSIVE_TOOLTIP);
                }
                if (this.pacifiesPhantoms()) {
                    tooltip.add((Component)ModTooltips.PHANTOM_PASSIVE_TOOLTIP);
                }
            } else if (this.pacifiesEndermen() || this.pacifiesPiglins() || this.pacifiesPhantoms()) {
                tooltip.add((Component)ModTooltips.SHIFT_KEY_TOOLTIP);
            }
            this.addTooltips(stack, context, tooltip, flag);
        }
    }

    @Internal
    public int getBarColor(ItemStack stack) {
        int originalColor = super.getBarColor(stack);
        if (this.customDurabilityBarColor(stack) != null && ConfigHelper.get().getClient().matchingDurabilityBars()) {
            return Objects.requireNonNull(this.customDurabilityBarColor(stack).getColor());
        }
        return AdvancedUtil.getDurabilityBarColor(originalColor, stack);
    }
}

