/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.api.impl.IAdvancedHooks;
import com.autovw.advancednetherite.common.item.AdvancedArmorItem;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;

@EventBusSubscriber(modid="advancednetherite", bus=EventBusSubscriber.Bus.GAME)
@Internal
public class EventHandler {
    @SubscribeEvent
    public static void onEnderManAngerEvent(EnderManAngerEvent event) {
        Player player = event.getPlayer();
        EnderMan enderMan = event.getEntity();
        if (player.isCreative()) {
            return;
        }
        for (ItemStack stack : player.getArmorSlots()) {
            Item item = stack.getItem();
            if ((!(item instanceof AdvancedArmorItem) || !((AdvancedArmorItem)item).pacifiesEndermen()) && (!(item instanceof IAdvancedHooks) || !((IAdvancedHooks)item).pacifyEndermen(stack))) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingChangeTargetEvent(LivingChangeTargetEvent event) {
        Item item;
        LivingEntity target = event.getOriginalAboutToBeSetTarget();
        LivingEntity attacker = event.getEntity();
        if (target == null) {
            return;
        }
        if (attacker.getLastHurtByMob() == target) {
            return;
        }
        if (attacker instanceof Phantom) {
            Phantom phantom = (Phantom)attacker;
            for (ItemStack stack : target.getArmorSlots()) {
                item = stack.getItem();
                if ((!(item instanceof AdvancedArmorItem) || !((AdvancedArmorItem)item).pacifiesPhantoms()) && (!(item instanceof IAdvancedHooks) || !((IAdvancedHooks)item).pacifyPhantoms(stack))) continue;
                event.setNewAboutToBeSetTarget(null);
            }
        }
        if (attacker instanceof Piglin) {
            Piglin piglin = (Piglin)attacker;
            for (ItemStack stack : target.getArmorSlots()) {
                item = stack.getItem();
                if ((!(item instanceof AdvancedArmorItem) || !((AdvancedArmorItem)item).pacifiesPiglins()) && (!(item instanceof IAdvancedHooks) || !((IAdvancedHooks)item).pacifyPiglins(stack))) continue;
                event.setCanceled(true);
            }
        }
    }
}

