/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common;

import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.util.ModArmorMaterials;
import com.autovw.advancednetherite.core.util.ModToolTiers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedUtil {
    public static int getArmorDurabilityMultiplier(Holder<ArmorMaterial> material) {
        if (material == ModArmorMaterials.NETHERITE_IRON) {
            return 39;
        }
        if (material == ModArmorMaterials.NETHERITE_GOLD) {
            return 41;
        }
        if (material == ModArmorMaterials.NETHERITE_EMERALD) {
            return 43;
        }
        if (material == ModArmorMaterials.NETHERITE_DIAMOND) {
            return 47;
        }
        return 0;
    }

    public static int getDurabilityBarColor(int originalColor, ItemStack stack) {
        int newColor = originalColor;
        if (ConfigHelper.get().getClient().matchingDurabilityBars()) {
            Item tier;
            DiggerItem item;
            Item item2 = stack.getItem();
            if (item2 instanceof DiggerItem) {
                item = (DiggerItem)item2;
                tier = item.getTier();
                if (tier == ModToolTiers.NETHERITE_IRON) {
                    newColor = ChatFormatting.GRAY.getColor();
                }
                if (tier == ModToolTiers.NETHERITE_GOLD) {
                    newColor = ChatFormatting.GOLD.getColor();
                }
                if (tier == ModToolTiers.NETHERITE_EMERALD) {
                    newColor = ChatFormatting.DARK_GREEN.getColor();
                }
                if (tier == ModToolTiers.NETHERITE_DIAMOND) {
                    newColor = ChatFormatting.AQUA.getColor();
                }
            }
            if ((tier = stack.getItem()) instanceof ArmorItem) {
                item = (ArmorItem)tier;
                Holder material = item.getMaterial();
                if (material == ModArmorMaterials.NETHERITE_IRON) {
                    newColor = ChatFormatting.GRAY.getColor();
                }
                if (material == ModArmorMaterials.NETHERITE_GOLD) {
                    newColor = ChatFormatting.GOLD.getColor();
                }
                if (material == ModArmorMaterials.NETHERITE_EMERALD) {
                    newColor = ChatFormatting.DARK_GREEN.getColor();
                }
                if (material == ModArmorMaterials.NETHERITE_DIAMOND) {
                    newColor = ChatFormatting.AQUA.getColor();
                }
            }
        }
        return newColor;
    }

    public static float getDestroySpeed(float originalSpeed, ItemStack stack, BlockState state) {
        float newSpeed = originalSpeed;
        Item item = stack.getItem();
        if (item instanceof DiggerItem) {
            DiggerItem diggerItem = (DiggerItem)item;
            Tier tier = diggerItem.getTier();
            if (diggerItem.isCorrectToolForDrops(stack, state)) {
                if (tier == ModToolTiers.NETHERITE_IRON) {
                    newSpeed *= (float)ConfigHelper.get().getServer().getToolProperties().getIronBreakingSpeedMultiplier();
                }
                if (tier == ModToolTiers.NETHERITE_GOLD) {
                    newSpeed *= (float)ConfigHelper.get().getServer().getToolProperties().getGoldBreakingSpeedMultiplier();
                }
                if (tier == ModToolTiers.NETHERITE_EMERALD) {
                    newSpeed *= (float)ConfigHelper.get().getServer().getToolProperties().getEmeraldBreakingSpeedMultiplier();
                }
                if (tier == ModToolTiers.NETHERITE_DIAMOND) {
                    newSpeed *= (float)ConfigHelper.get().getServer().getToolProperties().getDiamondBreakingSpeedMultiplier();
                }
            }
        }
        return newSpeed;
    }
}

