/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.api;

import com.autovw.advancednetherite.AdvancedNetherite;
import com.autovw.advancednetherite.api.annotation.Internal;
import com.mojang.logging.LogUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class TooltipBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();

    private TooltipBuilder() {
    }

    public static MutableComponent create(ResourceLocation key) {
        return TooltipBuilder.build(key, new Object[]{null});
    }

    public static MutableComponent create(ResourceLocation key, Object ... args) {
        return TooltipBuilder.build(key, args);
    }

    @Internal
    private static MutableComponent build(ResourceLocation key, Object ... args) {
        String content = "tooltip." + key.getNamespace() + "." + key.getPath();
        if (!content.endsWith(".")) {
            if (TooltipBuilder.makeArgs(args)) {
                return Component.translatable((String)content, (Object[])args);
            }
            return Component.translatable((String)content);
        }
        LOGGER.error("Cannot build tooltip ending with a dot (" + content + ")");
        if (!AdvancedNetherite.getPlatformHelper().isProduction()) {
            throw new IllegalStateException("Tried to build tooltip with incomplete name!");
        }
        return Component.empty();
    }

    @Internal
    private static boolean makeArgs(Object ... args) {
        for (Object arg : args) {
            if (arg == null) continue;
            return true;
        }
        return false;
    }
}

