/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens.styles;

import net.minecraft.resources.ResourceLocation;
import team.creative.creativecore.common.gui.style.Icon;

public class IconStyles {
    public static final ResourceLocation location = new ResourceLocation("waterframes", "textures/screen_atlas.png");
    public static final Icon VOLUME = IconStyles.create(0, 0);
    public static final Icon VOLUME_MUTED = IconStyles.create(0, 1);
    public static final Icon VOLUME_1 = IconStyles.create(0, 2);
    public static final Icon VOLUME_2 = IconStyles.create(0, 3);
    public static final Icon VOLUME_3 = IconStyles.create(0, 4);
    public static final Icon VOLUME_OVERFLOW = IconStyles.create(0, 5);
    public static final Icon VOLUME_RANGE_MIN = IconStyles.create(0, 6);
    public static final Icon VOLUME_RANGE_MAX = IconStyles.create(0, 7);
    public static final Icon AUDIO_POS_BLOCK = IconStyles.create(0, 13, 2);
    public static final Icon AUDIO_POS_CENTER = IconStyles.create(0, 14, 2);
    public static final Icon AUDIO_POS_PICTURE = IconStyles.create(0, 15, 2);
    public static final Icon EXPAND_X = IconStyles.create(1, 0);
    public static final Icon EXPAND_Y = IconStyles.create(1, 1);
    public static final Icon ROTATION = IconStyles.create(1, 2);
    public static final Icon TRANSPARENCY = IconStyles.create(1, 3);
    public static final Icon BRIGHTNESS = IconStyles.create(1, 4);
    public static final Icon REPEAT_ON = IconStyles.create(1, 5);
    public static final Icon REPEAT_OFF = IconStyles.create(1, 6);
    public static final Icon DISTANCE = IconStyles.create(1, 7);
    public static final Icon PROJECTION_DISTANCE = IconStyles.create(1, 8);
    public static final Icon VIDEOPLAYER_PLAY = IconStyles.create(1, 9);
    public static final Icon STATUS_OK = IconStyles.create(2, 0);
    public static final Icon STATUS_WARN = IconStyles.create(2, 1);
    public static final Icon STATUS_IDLE = IconStyles.create(2, 2);
    public static final Icon STATUS_ERROR = IconStyles.create(2, 3);
    public static final Icon STATUS_HACKED = IconStyles.create(2, 4);
    public static final Icon STATUS_PEM = IconStyles.create(2, 5);
    public static final Icon STATUS_AFFECTED = IconStyles.create(2, 6);
    public static final Icon STATUS_CASSETE_MODE = IconStyles.create(2, 7);
    public static final Icon STATUS_OFF = IconStyles.create(2, 8);
    public static final Icon POS_ICON = IconStyles.create(4, 12);
    public static final Icon POS_BASE = IconStyles.create(4, 13, 3, 3);
    public static final Icon PLAY = IconStyles.create(15, 0);
    public static final Icon PAUSE = IconStyles.create(15, 1);
    public static final Icon STOP = IconStyles.create(15, 2);
    public static final Icon FAST_FOWARD = IconStyles.create(15, 3);
    public static final Icon FAST_BACKWARD = IconStyles.create(15, 4);
    public static final Icon NEXT_MEDIA = IconStyles.create(15, 5);
    public static final Icon BACK_MEDIA = IconStyles.create(15, 6);
    public static final Icon ADD = IconStyles.create(15, 7);
    public static final Icon OFF_ON = IconStyles.create(15, 8);
    public static final Icon MUTE = IconStyles.create(15, 9);
    public static final Icon RELOAD = IconStyles.create(15, 10);
    public static final Icon VOLUME_DOWN = IconStyles.create(15, 11);
    public static final Icon VOLUME_UP = IconStyles.create(15, 12);
    public static final Icon CHANNEL_UP = IconStyles.create(15, 13);
    public static final Icon CHANNEL_DOWN = IconStyles.create(15, 14);

    private static Icon create(int chunkX, int chunkY) {
        return new Icon(location, 16 * chunkX, 16 * chunkY, 16, 16);
    }

    private static Icon create(int chunkX, int chunkY, int chunkXMultiplier) {
        return new Icon(location, 16 * chunkX, 16 * chunkY, 16 * chunkXMultiplier, 16);
    }

    private static Icon create(int chunkX, int chunkY, int chunkXMultiplier, int chunkYMultiplier) {
        return new Icon(location, 16 * chunkX, 16 * chunkY, 16 * chunkXMultiplier, 16 * chunkYMultiplier);
    }

    public static Icon getVolumeIcon(int volume, boolean muted) {
        if (muted) {
            return MUTE;
        }
        if (volume > 100) {
            return VOLUME_OVERFLOW;
        }
        if (volume >= 90) {
            return VOLUME;
        }
        if (volume >= 65) {
            return VOLUME_3;
        }
        if (volume >= 35) {
            return VOLUME_2;
        }
        if (volume >= 1) {
            return VOLUME_1;
        }
        return VOLUME_MUTED;
    }
}

