/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.item;

import java.util.List;
import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.WFRegistry;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.item.data.RemoteData;
import me.srrapero720.waterframes.common.screens.RemoteControlScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.gui.creator.ItemGuiCreator;

public class RemoteControl
extends Item
implements ItemGuiCreator {
    private static final Marker IT = MarkerManager.getMarker((String)RemoteControl.class.getSimpleName());

    public RemoteControl(Item.Properties pProperties) {
        super(pProperties.stacksTo(1).setNoRepair().fireResistant().rarity(Rarity.RARE));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!WFConfig.canInteractItem(player)) {
            this.sendFatal(player, Component.translatable((String)"waterframes.common.access.denied"));
            return InteractionResultHolder.fail((Object)stack);
        }
        RemoteData data = (RemoteData)stack.get(WFRegistry.REMOTE_DATA);
        if (data == null) {
            this.sendFailed(player, Component.translatable((String)"waterframes.remote.bound.failed"));
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.isCrouching()) {
            stack.set(WFRegistry.REMOTE_DATA, null);
            this.sendSuccess(player, Component.translatable((String)"waterframes.remote.unbound.success"));
            return InteractionResultHolder.success((Object)stack);
        }
        BlockPos blockPos = new BlockPos(data.x(), data.y(), data.z());
        ResourceLocation dimension = ResourceLocation.parse((String)data.dimension());
        if (level.getBlockEntity(blockPos) instanceof DisplayTile) {
            if (!level.dimension().location().equals((Object)dimension) || !Vec3.atCenterOf((Vec3i)blockPos).closerThan((Position)player.position(), (double)WFConfig.maxRcDis())) {
                this.sendFailed(player, Component.translatable((String)"waterframes.remote.distance.failed"));
                return InteractionResultHolder.fail((Object)stack);
            }
            CompoundTag tag = new CompoundTag();
            tag.putString("dimension", data.dimension());
            tag.putIntArray("position", data.getPos());
            GuiCreator.ITEM_OPENER.open(tag, player, hand);
            return InteractionResultHolder.success((Object)stack);
        }
        player.getItemInHand(hand).set(WFRegistry.REMOTE_DATA, null);
        this.sendFailed(player, Component.translatable((String)"waterframes.remote.display.failed"));
        return InteractionResultHolder.fail((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        RemoteData data = (RemoteData)context.getItemInHand().get(WFRegistry.REMOTE_DATA);
        if (player == null || context.getHand() == InteractionHand.OFF_HAND || data != null) {
            return InteractionResult.PASS;
        }
        if (!WFConfig.canInteractItem(player)) {
            this.sendFatal(player, Component.translatable((String)"waterframes.common.access.denied"));
            return InteractionResult.FAIL;
        }
        if (level.getBlockEntity(pos) instanceof DisplayTile) {
            ItemStack item = context.getItemInHand();
            item.set(WFRegistry.REMOTE_DATA, (Object)new RemoteData(level.dimension().location().toString(), pos.getX(), pos.getY(), pos.getZ()));
            this.sendSuccess(player, Component.translatable((String)"waterframes.remote.bound.success"));
            return InteractionResult.SUCCESS;
        }
        this.sendFailed(player, Component.translatable((String)"waterframes.remote.display.invalid"));
        return InteractionResult.FAIL;
    }

    private void sendSuccess(Player player, MutableComponent component) {
        if (player.level.isClientSide) {
            player.displayClientMessage((Component)component.withStyle(ChatFormatting.AQUA), true);
        }
    }

    private void sendFailed(Player player, MutableComponent component) {
        if (player.level.isClientSide) {
            player.displayClientMessage((Component)component.withStyle(ChatFormatting.RED), true);
        }
    }

    private void sendFatal(Player player, MutableComponent component) {
        if (player.level.isClientSide) {
            player.displayClientMessage((Component)component.withStyle(ChatFormatting.DARK_RED), true);
        }
    }

    public GuiLayer create(CompoundTag tag, Player player) {
        int[] pos = tag.getIntArray("position");
        BlockPos blockPos = new BlockPos(pos[0], pos[1], pos[2]);
        return new RemoteControlScreen(player, (DisplayTile)player.level.getBlockEntity(blockPos), tag, this);
    }

    public Component getHighlightTip(ItemStack item, Component displayName) {
        return Component.literal((String)displayName.getString()).withStyle(ChatFormatting.AQUA);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        Options opts = Minecraft.getInstance().options;
        pTooltipComponents.add((Component)Component.translatable((String)"waterframes.remote.description.1", (Object[])new Object[]{opts.keyShift.getKey().getDisplayName(), opts.keyUse.getKey().getDisplayName()}));
    }

    public boolean isFoil(ItemStack pStack) {
        return pStack.get(WFRegistry.REMOTE_DATA) != null;
    }

    public boolean canAttackBlock(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return false;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }
}

