/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block.entity;

import java.util.concurrent.Executor;
import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.display.TextureDisplay;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.data.DisplayCaps;
import me.srrapero720.waterframes.common.block.data.DisplayData;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.ActivePacket;
import me.srrapero720.waterframes.common.network.packets.LoopPacket;
import me.srrapero720.waterframes.common.network.packets.MutePacket;
import me.srrapero720.waterframes.common.network.packets.PausePacket;
import me.srrapero720.waterframes.common.network.packets.TimePacket;
import me.srrapero720.waterframes.common.network.packets.VolumePacket;
import me.srrapero720.watermedia.api.image.ImageAPI;
import me.srrapero720.watermedia.api.image.ImageCache;
import me.srrapero720.watermedia.api.math.MathAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;

@EventBusSubscriber(modid="waterframes", bus=EventBusSubscriber.Bus.GAME)
public class DisplayTile
extends BlockEntity {
    static long lagTickTime;
    public final DisplayData data;
    public final DisplayCaps caps;
    @OnlyIn(value=Dist.CLIENT)
    public ImageCache imageCache;
    @OnlyIn(value=Dist.CLIENT)
    public TextureDisplay display;
    @OnlyIn(value=Dist.CLIENT)
    private boolean isReleased;

    public DisplayTile(DisplayData data, DisplayCaps caps, BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.data = data;
        this.caps = caps;
    }

    public static void setLagTickTime(long ltt) {
        WaterFrames.LOGGER.warn("Server seems overloading, jumping {}ms or {} ticks", (Object)ltt, (Object)(ltt / 50L));
        lagTickTime = ltt;
    }

    public static void clearLagTickTime() {
        lagTickTime = 0L;
    }

    @SubscribeEvent
    public static void onTickLast(ServerTickEvent.Post e) {
        DisplayTile.clearLagTickTime();
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureDisplay requestDisplay() {
        if (!this.data.active || this.data.url.isEmpty() && this.display != null) {
            this.cleanDisplay();
            return null;
        }
        if (this.isReleased) {
            this.imageCache = null;
            return null;
        }
        if (this.imageCache == null || !this.imageCache.url.equals(this.data.url)) {
            this.imageCache = ImageAPI.getCache((String)this.data.url, (Executor)Minecraft.getInstance());
            this.cleanDisplay();
        }
        switch (this.imageCache.getStatus()) {
            case LOADING: 
            case FAILED: 
            case READY: {
                if (this.display != null) {
                    return this.display;
                }
                this.display = new TextureDisplay(this);
                return this.display;
            }
            case WAITING: {
                this.cleanDisplay();
                this.imageCache.load();
                return this.display;
            }
            case FORGOTTEN: {
                WaterFrames.LOGGER.warn("Cached picture is forgotten, cleaning and reloading");
                this.imageCache = null;
                return null;
            }
        }
        WaterFrames.LOGGER.warn("WATERMeDIA Behavior is modified, this shouldn't be executed");
        return null;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        this.data.save(nbt, this);
        super.saveAdditional(nbt, registries);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        this.data.load(nbt, this);
        super.loadAdditional(nbt, registries);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cleanDisplay() {
        if (this.display != null) {
            this.display.release();
            this.display = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void release() {
        this.cleanDisplay();
        this.isReleased = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AlignedBox getRenderBox() {
        return this.caps.getBox(this, this.getDirection(), this.getAttachedFace(), true);
    }

    public void setRemoved() {
        if (this.isClient()) {
            this.release();
        }
        super.setRemoved();
    }

    public void onChunkUnloaded() {
        if (this.isClient()) {
            this.release();
        }
        super.onChunkUnloaded();
    }

    public void setActive(boolean clientSide, boolean mode) {
        if (clientSide) {
            DisplayNetwork.sendServer(new ActivePacket(this.worldPosition, mode, true));
        } else {
            DisplayNetwork.sendClient(new ActivePacket(this.worldPosition, mode, true), this);
        }
    }

    public void setMute(boolean clientSide, boolean mode) {
        if (clientSide) {
            DisplayNetwork.sendServer(new MutePacket(this.worldPosition, mode, true));
        } else {
            DisplayNetwork.sendClient(new MutePacket(this.worldPosition, mode, true), this);
        }
    }

    public void setPause(boolean clientSide, boolean pause) {
        if (clientSide) {
            DisplayNetwork.sendServer(new PausePacket(this.worldPosition, pause, this.data.tick, true));
        } else {
            DisplayNetwork.sendClient(new PausePacket(this.worldPosition, pause, this.data.tick, true), this);
        }
    }

    public void setStop(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new PausePacket(this.worldPosition, true, 0L, true));
        } else {
            DisplayNetwork.sendClient(new PausePacket(this.worldPosition, true, 0L, true), this);
        }
    }

    public void volumeUp(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new VolumePacket(this.worldPosition, this.data.volume + 5, true));
        } else {
            DisplayNetwork.sendClient(new VolumePacket(this.worldPosition, this.data.volume + 5, true), this);
        }
    }

    public void volumeDown(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new VolumePacket(this.worldPosition, this.data.volume - 5, true));
        } else {
            DisplayNetwork.sendClient(new VolumePacket(this.worldPosition, this.data.volume - 5, true), this);
        }
    }

    public void fastFoward(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new TimePacket(this.worldPosition, Math.min(this.data.tick + (long)MathAPI.msToTick((long)5000L), this.data.tickMax), this.data.tickMax, true));
        } else {
            DisplayNetwork.sendClient(new TimePacket(this.worldPosition, Math.min(this.data.tick + 100L, this.data.tickMax), this.data.tickMax, true), this);
        }
    }

    public void rewind(boolean clientSide) {
        if (clientSide) {
            DisplayNetwork.sendServer(new TimePacket(this.worldPosition, Math.max(this.data.tick - (long)MathAPI.msToTick((long)5000L), 0L), this.data.tickMax, true));
        } else {
            DisplayNetwork.sendClient(new TimePacket(this.worldPosition, Math.max(this.data.tick - 100L, 0L), this.data.tickMax, true), this);
        }
    }

    public void syncTime(boolean clientSide, long tick, long maxTick) {
        if (clientSide) {
            DisplayNetwork.sendServer(new TimePacket(this.worldPosition, tick, maxTick, true));
        } else {
            DisplayNetwork.sendClient(new TimePacket(this.worldPosition, tick, maxTick, true), this);
        }
    }

    public void loop(boolean clientSide, boolean loop) {
        if (clientSide) {
            DisplayNetwork.sendServer(new LoopPacket(this.worldPosition, loop, true));
        } else {
            DisplayNetwork.sendClient(new LoopPacket(this.worldPosition, loop, true), this);
        }
    }

    public void tick(BlockPos pos, BlockState state) {
        TextureDisplay display;
        if (this.data.tickMax == -1L || this.data.tick < 0L) {
            this.data.tick = 0L;
        }
        if (!this.data.paused && this.data.active) {
            if (this.data.tick < this.data.tickMax) {
                ++this.data.tick;
                if (lagTickTime != 0L && this.isServer()) {
                    this.data.tick += lagTickTime / 50L;
                    if (this.data.tick > this.data.tickMax) {
                        this.data.tick -= this.data.tickMax;
                    }
                    if (this.data.tick < 0L) {
                        this.data.tick = 0L;
                    }
                    this.setDirty();
                }
            } else if (this.data.loop || this.data.tickMax == -1L) {
                this.data.tick = 0L;
            }
        }
        boolean updateBlock = false;
        int redstoneOutput = 0;
        if (this.data.tickMax > 0L && this.data.active) {
            redstoneOutput = Math.round((float)this.data.tick / (float)this.data.tickMax * 14.0f) + 1;
        }
        boolean lightOnPlay = WFConfig.useLightOnPlay();
        boolean lit = (Boolean)state.getValue((Property)DisplayBlock.LIT);
        if (lightOnPlay && lit == this.data.url.isEmpty()) {
            state = (BlockState)state.setValue((Property)DisplayBlock.LIT, (Comparable)Boolean.valueOf(!this.data.url.isEmpty()));
            updateBlock = true;
        } else if (!lightOnPlay && lit) {
            state = (BlockState)state.setValue((Property)DisplayBlock.LIT, (Comparable)Boolean.valueOf(false));
            updateBlock = true;
        }
        if ((Integer)state.getValue((Property)DisplayBlock.POWER) != redstoneOutput) {
            state = (BlockState)state.setValue((Property)DisplayBlock.POWER, (Comparable)Integer.valueOf(redstoneOutput));
            updateBlock = true;
        }
        if (updateBlock) {
            this.level.setBlock(pos, state, 3);
        }
        if (this.isClient() && (display = this.requestDisplay()) != null && display.canTick()) {
            display.tick(pos);
        }
    }

    public boolean isClient() {
        return this.level != null && this.level.isClientSide;
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)this.getDisplayBlock().getFacing());
    }

    public Direction getAttachedFace() {
        return (Direction)this.getBlockState().getValue((Property)DisplayBlock.ATTACHED_FACE);
    }

    public boolean canHideModel() {
        return this.getBlockState().hasProperty((Property)DisplayBlock.VISIBLE);
    }

    public boolean isVisible() {
        return (Boolean)this.getBlockState().getValue((Property)DisplayBlock.VISIBLE);
    }

    public void setVisibility(boolean visible) {
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)DisplayBlock.VISIBLE, (Comparable)Boolean.valueOf(visible)), 2);
    }

    public DisplayBlock getDisplayBlock() {
        return (DisplayBlock)this.getBlockState().getBlock();
    }

    public boolean isPowered() {
        return (Boolean)this.getBlockState().getValue((Property)DisplayBlock.POWERED);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.data.load(tag, this);
        this.setDirty();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return super.saveWithFullMetadata(pRegistries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setDirty() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        } else {
            WaterFrames.LOGGER.warn("Cannot be stored block data, level is NULL");
        }
    }

    public static AlignedBox getBasicBox(DisplayTile tile) {
        Facing facing = Facing.get((Direction)tile.getDirection());
        AlignedBox box = new AlignedBox();
        if (facing.positive) {
            box.setMax(facing.axis, tile.data.projectionDistance);
        } else {
            box.setMin(facing.axis, 1.0f - tile.data.projectionDistance);
        }
        Axis one = facing.one();
        Axis two = facing.two();
        if (facing.axis != Axis.Z) {
            one = facing.two();
            two = facing.one();
        }
        box.setMin(one, tile.data.min.x);
        box.setMax(one, tile.data.max.x);
        box.setMin(two, tile.data.min.y);
        box.setMax(two, tile.data.max.y);
        if (tile.caps.projects() && (facing.toVanilla() == Direction.NORTH || facing.toVanilla() == Direction.EAST)) {
            switch (tile.data.getPosX()) {
                case LEFT: {
                    box.setMin(one, 1.0f - tile.data.getWidth());
                    box.setMax(one, 1.0f);
                    break;
                }
                case RIGHT: {
                    box.setMax(one, tile.data.getWidth());
                    box.setMin(one, 0.0f);
                }
            }
        }
        if (!(tile.caps.projects() || facing.toVanilla() != Direction.WEST && facing.toVanilla() != Direction.SOUTH)) {
            switch (tile.data.getPosX()) {
                case LEFT: {
                    box.setMin(one, 1.0f - tile.data.getWidth());
                    box.setMax(one, 1.0f);
                    break;
                }
                case RIGHT: {
                    box.setMax(one, tile.data.getWidth());
                    box.setMin(one, 0.0f);
                }
            }
        }
        return box;
    }
}

