/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block.data;

import java.util.UUID;
import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.data.types.AudioPosition;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.DisplayScreen;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.Property;
import team.creative.creativecore.common.util.math.vec.Vec2f;

public class DisplayData {
    public static final String URL = "url";
    public static final String PLAYER_UUID = "player_uuid";
    public static final String ACTIVE = "active";
    public static final String MIN_X = "min_x";
    public static final String MIN_Y = "min_y";
    public static final String MAX_X = "max_x";
    public static final String MAX_Y = "max_y";
    public static final String FLIP_X = "flip_x";
    public static final String FLIP_Y = "flip_y";
    public static final String ROTATION = "rotation";
    public static final String ALPHA = "alpha";
    public static final String BRIGHTNESS = "brightness";
    public static final String RENDER_DISTANCE = "render_distance";
    public static final String VOLUME = "volume";
    public static final String VOL_RANGE_MIN = "volume_min_range";
    public static final String VOL_RANGE_MAX = "volume_max_range";
    public static final String LOOP = "loop";
    public static final String PAUSED = "paused";
    public static final String MUTED = "muted";
    public static final String TICK = "tick";
    public static final String TICK_MAX = "tick_max";
    public static final String DATA_V = "data_v";
    public static final String RENDER_BOTH_SIDES = "render_both";
    public static final String PROJECTION_DISTANCE = "projection_distance";
    public static final String AUDIO_OFFSET = "audio_offset";
    public static final short V = 2;
    public String url = "";
    public UUID uuid = Util.NIL_UUID;
    public boolean active = true;
    public final Vec2f min = new Vec2f(0.0f, 0.0f);
    public final Vec2f max = new Vec2f(1.0f, 1.0f);
    public boolean flipX = false;
    public boolean flipY = false;
    public float rotation = 0.0f;
    public int alpha = 255;
    public int brightness = 255;
    public int renderDistance = WFConfig.maxRenDis(32);
    public int volume = WFConfig.maxVol();
    public int maxVolumeDistance = WFConfig.maxVolDis(20);
    public int minVolumeDistance = Math.min(5, this.maxVolumeDistance);
    public boolean loop = true;
    public boolean paused = false;
    public boolean muted = false;
    public long tick = 0L;
    public long tickMax = -1L;
    public boolean renderBothSides = false;
    public float projectionDistance = WFConfig.maxProjDis(8.0f);
    public float audioOffset = 0.0f;

    public PositionHorizontal getPosX() {
        return this.min.x == 0.0f ? PositionHorizontal.LEFT : (this.max.x == 1.0f ? PositionHorizontal.RIGHT : PositionHorizontal.CENTER);
    }

    public PositionVertical getPosY() {
        return this.min.y == 0.0f ? PositionVertical.TOP : (this.max.y == 1.0f ? PositionVertical.BOTTOM : PositionVertical.CENTER);
    }

    public float getWidth() {
        return this.max.x - this.min.x;
    }

    public float getHeight() {
        return this.max.y - this.min.y;
    }

    public void save(CompoundTag nbt, DisplayTile tile) {
        nbt.putString(URL, this.url);
        nbt.putUUID(PLAYER_UUID, this.uuid);
        nbt.putBoolean(ACTIVE, this.active);
        if (tile.caps.resizes()) {
            nbt.putFloat(MIN_X, this.min.x);
            nbt.putFloat(MIN_Y, this.min.y);
            nbt.putFloat(MAX_X, this.max.x);
            nbt.putFloat(MAX_Y, this.max.y);
            nbt.putFloat(ROTATION, this.rotation);
        }
        nbt.putInt(RENDER_DISTANCE, this.renderDistance);
        nbt.putBoolean(FLIP_X, this.flipX);
        nbt.putBoolean(FLIP_Y, this.flipY);
        nbt.putInt(ALPHA, this.alpha);
        nbt.putInt(BRIGHTNESS, this.brightness);
        nbt.putInt(VOLUME, this.volume);
        nbt.putInt(VOL_RANGE_MIN, this.minVolumeDistance);
        nbt.putInt(VOL_RANGE_MAX, this.maxVolumeDistance);
        nbt.putBoolean(PAUSED, this.paused);
        nbt.putBoolean(MUTED, this.muted);
        nbt.putLong(TICK, this.tick);
        nbt.putLong(TICK_MAX, this.tickMax);
        nbt.putBoolean(LOOP, this.loop);
        if (tile.caps.renderBehind()) {
            nbt.putBoolean(RENDER_BOTH_SIDES, this.renderBothSides);
        }
        if (tile.caps.projects()) {
            nbt.putFloat(PROJECTION_DISTANCE, this.projectionDistance);
            nbt.putFloat(AUDIO_OFFSET, this.audioOffset);
        }
        nbt.putShort(DATA_V, (short)2);
    }

    public void load(CompoundTag nbt, DisplayTile tile) {
        this.url = nbt.getString(URL);
        this.uuid = nbt.contains(PLAYER_UUID) ? nbt.getUUID(PLAYER_UUID) : this.uuid;
        boolean bl = this.active = nbt.contains(ACTIVE) ? nbt.getBoolean(ACTIVE) : this.active;
        if (tile.caps.resizes()) {
            this.min.x = nbt.getFloat(MIN_X);
            this.min.y = nbt.getFloat(MIN_Y);
            this.max.x = nbt.getFloat(MAX_X);
            this.max.y = nbt.getFloat(MAX_Y);
            this.rotation = nbt.getFloat(ROTATION);
        }
        this.renderDistance = WFConfig.maxRenDis(nbt.getInt(RENDER_DISTANCE));
        this.flipX = nbt.getBoolean(FLIP_X);
        this.flipY = nbt.getBoolean(FLIP_Y);
        this.alpha = nbt.contains(ALPHA) ? nbt.getInt(ALPHA) : this.alpha;
        this.brightness = nbt.contains(BRIGHTNESS) ? nbt.getInt(BRIGHTNESS) : this.alpha;
        this.volume = nbt.contains(VOLUME) ? WFConfig.maxVol(nbt.getInt(VOLUME)) : this.volume;
        this.maxVolumeDistance = nbt.contains(VOL_RANGE_MAX) ? WFConfig.maxVolDis(nbt.getInt(VOL_RANGE_MAX)) : this.maxVolumeDistance;
        this.minVolumeDistance = nbt.contains(VOL_RANGE_MIN) ? Math.min(nbt.getInt(VOL_RANGE_MIN), this.maxVolumeDistance) : this.minVolumeDistance;
        this.paused = nbt.getBoolean(PAUSED);
        this.muted = nbt.getBoolean(MUTED);
        this.tick = nbt.getLong(TICK);
        this.tickMax = nbt.contains(TICK_MAX) ? nbt.getLong(TICK_MAX) : this.tickMax;
        this.loop = nbt.getBoolean(LOOP);
        if (tile.caps.renderBehind()) {
            this.renderBothSides = nbt.getBoolean(RENDER_BOTH_SIDES);
        }
        if (tile.caps.projects()) {
            this.projectionDistance = nbt.contains(PROJECTION_DISTANCE) ? WFConfig.maxProjDis(nbt.getInt(PROJECTION_DISTANCE)) : this.projectionDistance;
            this.audioOffset = nbt.contains(AUDIO_OFFSET) ? nbt.getFloat(AUDIO_OFFSET) : this.audioOffset;
        }
        switch (nbt.getShort(DATA_V)) {
            case 1: {
                this.alpha = (int)(nbt.getFloat(ALPHA) * 255.0f);
                this.brightness = (int)(nbt.getFloat(BRIGHTNESS) * 255.0f);
                break;
            }
            default: {
                if (!nbt.contains("maxx")) {
                    return;
                }
                this.min.x = nbt.getFloat("minx");
                this.min.y = nbt.getFloat("miny");
                this.max.x = nbt.getFloat("maxx");
                this.max.y = nbt.getFloat("maxy");
                this.flipX = nbt.getBoolean("flipX");
                this.flipY = nbt.getBoolean("flipY");
                this.maxVolumeDistance = WFConfig.maxVolDis((int)nbt.getFloat("max"));
                this.minVolumeDistance = Math.min((int)nbt.getFloat("min"), this.maxVolumeDistance);
                this.renderDistance = nbt.getInt("render");
                if (tile.canHideModel()) {
                    tile.setVisibility(nbt.getBoolean("visibleFrame"));
                }
                if (!tile.caps.renderBehind()) break;
                this.renderBothSides = nbt.getBoolean("bothSides");
            }
        }
        this.restrictWidth();
        this.restrictHeight();
    }

    public void setAudioPosition(AudioPosition position) {
        this.audioOffset = switch (position) {
            default -> throw new MatchException(null, null);
            case AudioPosition.BLOCK -> 0.0f;
            case AudioPosition.PROJECTION -> this.projectionDistance;
            case AudioPosition.CENTER -> this.projectionDistance / 2.0f;
        };
    }

    public AudioPosition getAudioPosition() {
        return this.audioOffset == 0.0f ? AudioPosition.BLOCK : (this.audioOffset == this.projectionDistance ? AudioPosition.PROJECTION : AudioPosition.CENTER);
    }

    public void setWidth(float width) {
        this.setWidth(this.getPosX(), width);
    }

    public void setWidth(PositionHorizontal position, float width) {
        switch (position) {
            case LEFT: {
                this.min.x = 0.0f;
                this.max.x = width;
                break;
            }
            case RIGHT: {
                this.min.x = 1.0f - width;
                this.max.x = 1.0f;
                break;
            }
            default: {
                float middle = width / 2.0f;
                this.min.x = 0.5f - middle;
                this.max.x = 0.5f + middle;
            }
        }
    }

    public void setHeight(float height) {
        this.setHeight(this.getPosY(), height);
    }

    public void setHeight(PositionVertical position, float height) {
        switch (position) {
            case TOP: {
                this.min.y = 0.0f;
                this.max.y = height;
                break;
            }
            case BOTTOM: {
                this.min.y = 1.0f - height;
                this.max.y = 1.0f;
                break;
            }
            default: {
                float middle = height / 2.0f;
                this.min.y = 0.5f - middle;
                this.max.y = 0.5f + middle;
            }
        }
    }

    private void restrictWidth() {
        float maxWidth = WFConfig.maxWidth();
        if (this.getWidth() > maxWidth) {
            switch (this.getPosX()) {
                case LEFT: {
                    this.min.x = 0.0f;
                    this.max.x = maxWidth;
                    break;
                }
                case RIGHT: {
                    this.min.x = 1.0f - maxWidth;
                    this.max.x = 1.0f;
                    break;
                }
                default: {
                    float middle = maxWidth / 2.0f;
                    this.min.x = 0.5f - middle;
                    this.max.x = 0.5f + middle;
                }
            }
        }
    }

    public DisplayData setProjectionDistance(float projectionDistance) {
        this.projectionDistance = projectionDistance;
        return this;
    }

    private void restrictHeight() {
        float maxHeight = WFConfig.maxHeight();
        if (this.getHeight() > maxHeight) {
            switch (this.getPosY()) {
                case TOP: {
                    this.min.y = 0.0f;
                    this.max.y = maxHeight;
                    break;
                }
                case BOTTOM: {
                    this.min.y = 1.0f - maxHeight;
                    this.max.y = 1.0f;
                    break;
                }
                default: {
                    float middle = maxHeight / 2.0f;
                    this.min.y = 0.5f - middle;
                    this.max.y = 0.5f + middle;
                }
            }
        }
    }

    public static CompoundTag build(DisplayScreen screen, DisplayTile tile) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString(URL, screen.url.getText());
        nbt.putBoolean(ACTIVE, true);
        if (tile.caps.resizes()) {
            nbt.putFloat("width", Math.max(0.1f, (float)screen.widthField.getValue()));
            nbt.putFloat("height", Math.max(0.1f, (float)screen.heightField.getValue()));
            nbt.putInt("pos_x", screen.pos_view.getX().ordinal());
            nbt.putInt("pos_y", screen.pos_view.getY().ordinal());
            nbt.putFloat(ROTATION, (float)screen.rotation.getValue());
        }
        nbt.putBoolean(FLIP_X, screen.flip_x.value);
        nbt.putBoolean(FLIP_Y, screen.flip_y.value);
        nbt.putInt(ALPHA, screen.alpha.getIntValue());
        nbt.putInt(BRIGHTNESS, screen.brightness.getIntValue());
        nbt.putInt(RENDER_DISTANCE, screen.render_distance.getIntValue());
        nbt.putInt(VOLUME, screen.volume.getIntValue());
        nbt.putInt(VOL_RANGE_MIN, screen.volume_min.getIntValue());
        nbt.putInt(VOL_RANGE_MAX, screen.volume_max.getIntValue());
        if (tile.getBlockState().hasProperty((Property)DisplayBlock.VISIBLE)) {
            nbt.putBoolean("visible", screen.show_model.value);
        }
        if (tile.caps.renderBehind()) {
            nbt.putBoolean(RENDER_BOTH_SIDES, screen.render_behind.value);
        }
        if (tile.caps.projects()) {
            nbt.putFloat(PROJECTION_DISTANCE, (float)screen.projection_distance.getValue());
            nbt.putInt(AUDIO_OFFSET, screen.audioOffset.getState());
        }
        return nbt;
    }

    public static void sync(DisplayTile tile, Player player, CompoundTag nbt) {
        String url = nbt.getString(URL);
        if (WFConfig.canSave(player, url)) {
            if (!tile.data.url.equals(url)) {
                tile.data.tick = 0L;
                tile.data.tickMax = -1L;
            }
            tile.data.url = url;
            tile.data.uuid = !tile.data.url.isEmpty() ? player.getUUID() : Util.NIL_UUID;
            tile.data.active = nbt.getBoolean(ACTIVE);
            if (tile.caps.resizes()) {
                float width = WFConfig.maxWidth(nbt.getFloat("width"));
                float height = WFConfig.maxHeight(nbt.getFloat("height"));
                int posX = nbt.getInt("pos_x");
                int posY = nbt.getInt("pos_y");
                tile.data.setWidth(PositionHorizontal.VALUES[posX], width);
                tile.data.setHeight(PositionVertical.VALUES[posY], height);
                tile.data.rotation = nbt.getFloat(ROTATION);
            }
            tile.data.flipX = nbt.getBoolean(FLIP_X);
            tile.data.flipY = nbt.getBoolean(FLIP_Y);
            tile.data.alpha = nbt.getInt(ALPHA);
            tile.data.brightness = nbt.getInt(BRIGHTNESS);
            tile.data.renderDistance = WFConfig.maxRenDis(nbt.getInt(RENDER_DISTANCE));
            tile.data.volume = WFConfig.maxVol(nbt.getInt(VOLUME));
            tile.data.maxVolumeDistance = WFConfig.maxVolDis(nbt.getInt(VOL_RANGE_MAX));
            tile.data.minVolumeDistance = Math.min(nbt.getInt(VOL_RANGE_MIN), tile.data.maxVolumeDistance);
            if (tile.data.minVolumeDistance > tile.data.maxVolumeDistance) {
                tile.data.maxVolumeDistance = tile.data.minVolumeDistance;
            }
            if (tile.canHideModel()) {
                tile.setVisibility(nbt.getBoolean("visible"));
            }
            if (tile.caps.renderBehind()) {
                tile.data.renderBothSides = nbt.getBoolean(RENDER_BOTH_SIDES);
            }
            if (tile.caps.projects()) {
                int mode = nbt.getInt(AUDIO_OFFSET);
                tile.data.projectionDistance = WFConfig.maxProjDis(nbt.getFloat(PROJECTION_DISTANCE));
                tile.data.setAudioPosition(AudioPosition.VALUES[mode]);
            }
        }
        tile.setDirty();
    }
}

