/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block;

import com.mojang.serialization.MapCodec;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.entity.FrameTile;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;

@MethodsReturnNonnullByDefault
public class FrameBlock
extends DisplayBlock {
    public static final float THICKNESS = 0.03125f;
    public static final MapCodec<FrameBlock> CODEC = FrameBlock.simpleCodec(FrameBlock::new);

    public FrameBlock() {
    }

    public FrameBlock(BlockBehaviour.Properties p) {
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public DirectionProperty getFacing() {
        return BlockStateProperties.FACING;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Facing facing = Facing.get((Direction)((Direction)state.getValue((Property)this.getFacing())));
        AlignedBox box = new AlignedBox();
        if (facing.positive) {
            box.setMax(facing.axis, 0.03125f);
        } else {
            box.setMin(facing.axis, 0.96875f);
        }
        return box.voxelShape();
    }

    @Override
    public void registerDefaultState(BlockState state) {
        super.registerDefaultState((BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{VISIBLE}));
    }

    @Override
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)this.getFacing(), (Comparable)context.getClickedFace());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FrameTile(pos, state);
    }
}

