/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.block;

import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.PermLevelPacket;
import me.srrapero720.waterframes.common.screens.DisplayScreen;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.BlockGuiCreator;
import team.creative.creativecore.common.gui.creator.GuiCreator;

@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public abstract class DisplayBlock
extends BaseEntityBlock
implements BlockGuiCreator,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty VISIBLE = new BooleanProperty("frame"){};
    public static final DirectionProperty ATTACHED_FACE = DirectionProperty.create((String)"attached_face", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});
    private static final BlockBehaviour.Properties PROPERTIES = BlockBehaviour.Properties.of().strength(1.0f).sound(SoundType.METAL).noOcclusion().forceSolidOff().isSuffocating(Blocks::never).isViewBlocking(Blocks::never).requiresCorrectToolForDrops();

    protected DisplayBlock() {
        super(PROPERTIES);
    }

    public abstract DirectionProperty getFacing();

    public GuiLayer create(CompoundTag tag, Level level, BlockPos blockPos, BlockState blockState, Player player) {
        DisplayScreen displayScreen;
        BlockEntity blockEntity;
        if (!level.isClientSide) {
            DisplayNetwork.sendClient(new PermLevelPacket(level.getServer()), level, blockPos);
        }
        if ((blockEntity = level.getBlockEntity(blockPos)) instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)blockEntity;
            displayScreen = new DisplayScreen(tile);
        } else {
            displayScreen = null;
        }
        return displayScreen;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.isClientSide && WFConfig.canInteractBlock(player)) {
            GuiCreator.BLOCK_OPENER.open(player, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide && WFConfig.canInteractBlock(player)) {
            GuiCreator.BLOCK_OPENER.open(player, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.getValue((Property)this.getFacing()) == direction;
    }

    public void registerDefaultState(BlockState state) {
        super.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{this.getFacing()}).add(new Property[]{ATTACHED_FACE}).add(new Property[]{POWERED}).add(new Property[]{POWER}).add(new Property[]{WATERLOGGED}).add(new Property[]{LIT}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction current = context.getHorizontalDirection();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)ATTACHED_FACE, (Comparable)context.getClickedFace())).setValue((Property)this.getFacing(), (Comparable)(context.getPlayer().isCrouching() ? current.getOpposite() : current))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape getRenderShape(BlockState state) {
        return state.hasProperty((Property)VISIBLE) ? (((Boolean)state.getValue((Property)VISIBLE)).booleanValue() ? RenderShape.MODEL : RenderShape.INVISIBLE) : RenderShape.MODEL;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getShape(state, level, pos, null);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return (l, pos, state, be) -> {
            if (be instanceof DisplayTile) {
                DisplayTile tile = (DisplayTile)be;
                tile.tick(tile.getBlockPos(), state);
            }
        };
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(state, level, pos, block, neighborPos, isMoving);
        if (!WFConfig.useRedstone() || !((blockEntity = level.getBlockEntity(pos)) instanceof DisplayTile)) {
            return;
        }
        DisplayTile tile = (DisplayTile)blockEntity;
        boolean signal = level.hasNeighborSignal(pos);
        if ((Boolean)state.getValue((Property)POWERED) != signal) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(signal)), 3);
            if (!level.isClientSide) {
                tile.setPause(false, signal);
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)POWER);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return level.getMaxLightLevel();
        }
        return 0;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.0f;
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.DESTROY;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(true) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return this.rotate(state, rotation);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)this.getFacing(), (Comparable)rotation.rotate((Direction)state.getValue((Property)this.getFacing())));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)this.getFacing(), (Comparable)mirror.mirror((Direction)state.getValue((Property)this.getFacing())));
    }
}

