/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.rendering.core;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.Vec3i;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;

public class RenderCore {
    private static final Tesselator tesselator = Tesselator.getInstance();
    private static BufferBuilder builder;

    public static void cleanShader() {
        ShaderInstance shader = RenderSystem.getShader();
        shader.apply();
        shader.clear();
    }

    public static void bufferPrepare() {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
    }

    public static BufferBuilder bufferBegin() {
        if (builder != null) {
            RenderCore.bufferFinish();
        }
        builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR_NORMAL);
        return builder;
    }

    public static void bufferFinish() {
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        builder = null;
    }

    public static void bindTex(int texture) {
        RenderSystem.bindTexture((int)texture);
        RenderSystem.setShaderTexture((int)0, (int)texture);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
    }

    public static void unbindTex() {
        RenderSystem.bindTexture((int)0);
        RenderSystem.setShaderTexture((int)0, (int)0);
    }

    public static void vertexF(PoseStack pose, AlignedBox box, BoxFace face, boolean flipX, boolean flipY, int a, int r, int g, int b) {
        for (int i = 0; i < face.corners.length; ++i) {
            RenderCore.vertex(pose, box, face, face.corners[i], flipX, flipY, a, r, g, b);
        }
    }

    public static void vertexB(PoseStack pose, AlignedBox box, BoxFace face, boolean flipX, boolean flipY, int a, int r, int g, int b) {
        for (int i = face.corners.length - 1; i >= 0; --i) {
            RenderCore.vertex(pose, box, face, face.corners[i], flipX, flipY, a, r, g, b);
        }
    }

    private static void vertex(PoseStack pose, AlignedBox box, BoxFace face, BoxCorner corner, boolean flipX, boolean flipY, int a, int r, int g, int b) {
        Vec3i normal = face.facing.normal;
        builder.addVertex(pose.last().pose(), box.get(corner.x), box.get(corner.y), box.get(corner.z)).setUv(corner.isFacing(face.getTexU()) != flipX ? 1.0f : 0.0f, corner.isFacing(face.getTexV()) != flipY ? 1.0f : 0.0f).setUv1(corner.isFacing(face.getTexU()) != flipX ? 1 : 0, corner.isFacing(face.getTexV()) != flipY ? 1 : 0).setUv2(corner.isFacing(face.getTexU()) != flipX ? 1 : 0, corner.isFacing(face.getTexV()) != flipY ? 1 : 0).setColor(r, g, b, a).setNormal(pose.last(), (float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
    }
}

