/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.display;

import me.srrapero720.waterframes.client.display.TextureDisplay;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPauseChangeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@EventBusSubscriber(value={Dist.CLIENT}, modid="waterframes", bus=EventBusSubscriber.Bus.GAME)
@OnlyIn(value=Dist.CLIENT)
public class DisplayControl {
    private static final Marker IT = MarkerManager.getMarker((String)"DisplayControl");
    public static final Integer DEFAULT_SIZE = 32;
    public static final int SYNC_TIME = 1000;
    private static volatile TextureDisplay[] displays = new TextureDisplay[DEFAULT_SIZE.intValue()];
    private static int position = 0;
    private static boolean checkSize = false;
    private static long ticks = 0L;
    private static boolean paused;

    public static void add(TextureDisplay display) {
        TextureDisplay[] freshMeal;
        if (checkSize) {
            if ((float)position / (float)displays.length <= 0.25f) {
                freshMeal = new TextureDisplay[displays.length / 2];
                System.arraycopy(displays, 0, freshMeal, 0, position);
                displays = freshMeal;
            }
            checkSize = false;
        }
        if (position >= displays.length) {
            freshMeal = new TextureDisplay[displays.length * 2];
            position = DisplayControl.copyData$resetPosition(displays, freshMeal);
            displays = freshMeal;
            checkSize = true;
        }
        if (paused) {
            display.setPauseMode(true);
        }
        DisplayControl.displays[DisplayControl.position++] = display;
    }

    public static void pause() {
        paused = true;
        for (int i = 0; i < position; ++i) {
            if (displays[i] == null) continue;
            displays[i].setPauseMode(true);
        }
    }

    public static void resume() {
        paused = false;
        for (int i = 0; i < position; ++i) {
            if (displays[i] == null) continue;
            displays[i].setPauseMode(false);
        }
    }

    public static void remove(int i) {
        if (i > displays.length) {
            return;
        }
        DisplayControl.displays[i] = null;
    }

    public static void remove(TextureDisplay obj) {
        if (obj == null) {
            return;
        }
        for (int i = 0; i < position; ++i) {
            if (obj != displays[i]) continue;
            DisplayControl.displays[i] = null;
            break;
        }
    }

    public static void release() {
        for (int i = 0; i < position; ++i) {
            if (displays[i] == null) continue;
            displays[i].release();
            DisplayControl.displays[i] = null;
        }
        displays = new TextureDisplay[DEFAULT_SIZE.intValue()];
        position = 0;
    }

    private static int copyData$resetPosition(TextureDisplay[] current, TextureDisplay[] target) {
        int freshPosition = 0;
        for (int i = 0; i < current.length; ++i) {
            if (current[i] == null) continue;
            target[freshPosition++] = current[i];
            current[i] = null;
        }
        return freshPosition;
    }

    public static void tick() {
        if (++ticks == Long.MAX_VALUE) {
            ticks = 0L;
        }
    }

    public static long getTicks() {
        return ticks;
    }

    @SubscribeEvent
    public static void onUnloadingLevel(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        if (level.isClientSide()) {
            DisplayControl.release();
        }
    }

    @SubscribeEvent
    public static void onClientTickEvent(ClientTickEvent.Post event) {
        DisplayControl.tick();
    }

    @SubscribeEvent
    public static void onClientPause(ClientPauseChangeEvent.Post event) {
        if (event.isPaused()) {
            DisplayControl.pause();
        } else {
            DisplayControl.resume();
        }
    }
}

