/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Supplier;
import me.srrapero720.waterframes.client.rendering.DisplayRenderer;
import me.srrapero720.waterframes.common.block.BigTvBlock;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.FrameBlock;
import me.srrapero720.waterframes.common.block.ProjectorBlock;
import me.srrapero720.waterframes.common.block.TvBlock;
import me.srrapero720.waterframes.common.block.entity.BigTvTile;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.block.entity.FrameTile;
import me.srrapero720.waterframes.common.block.entity.ProjectorTile;
import me.srrapero720.waterframes.common.block.entity.TvTile;
import me.srrapero720.waterframes.common.commands.WaterFramesCommand;
import me.srrapero720.waterframes.common.item.RemoteControl;
import me.srrapero720.waterframes.common.item.data.CodecManager;
import me.srrapero720.waterframes.common.item.data.RemoteData;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.ActivePacket;
import me.srrapero720.waterframes.common.network.packets.DataSyncPacket;
import me.srrapero720.waterframes.common.network.packets.LoopPacket;
import me.srrapero720.waterframes.common.network.packets.MutePacket;
import me.srrapero720.waterframes.common.network.packets.PausePacket;
import me.srrapero720.waterframes.common.network.packets.PermLevelPacket;
import me.srrapero720.waterframes.common.network.packets.TimePacket;
import me.srrapero720.waterframes.common.network.packets.VolumePacket;
import me.srrapero720.waterframes.common.network.packets.VolumeRangePacket;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforgespi.locating.IModFile;

@EventBusSubscriber(modid="waterframes", bus=EventBusSubscriber.Bus.GAME)
public class WFRegistry {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"waterframes");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"waterframes");
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"waterframes");
    public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"waterframes");
    public static final DeferredRegister<DataComponentType<?>> DATA = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"waterframes");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<RemoteData>> REMOTE_DATA = DATA.register("remote", () -> new DataComponentType.Builder().persistent(CodecManager.REMOTE_CODEC).networkSynchronized(CodecManager.REMOTE_STREAM_CODEC).build());
    public static final DeferredBlock<DisplayBlock> FRAME = BLOCKS.register("frame", () -> new FrameBlock());
    public static final DeferredBlock<DisplayBlock> PROJECTOR = BLOCKS.register("projector", () -> new ProjectorBlock());
    public static final DeferredBlock<DisplayBlock> TV = BLOCKS.register("tv", () -> new TvBlock());
    public static final DeferredBlock<DisplayBlock> BIG_TV = BLOCKS.register("big_tv", () -> new BigTvBlock());
    public static final DeferredItem<Item> REMOTE_ITEM = ITEMS.register("remote", () -> new RemoteControl(new Item.Properties()));
    public static final DeferredItem<Item> FRAME_ITEM = ITEMS.register("frame", () -> new BlockItem((Block)FRAME.get(), WFRegistry.prop()));
    public static final DeferredItem<Item> PROJECTOR_ITEM = ITEMS.register("projector", () -> new BlockItem((Block)PROJECTOR.get(), WFRegistry.prop()));
    public static final DeferredItem<Item> TV_ITEM = ITEMS.register("tv", () -> new BlockItem((Block)TV.get(), WFRegistry.prop()));
    public static final DeferredItem<Item> BIG_TV_ITEM = ITEMS.register("big_tv", () -> new BlockItem((Block)BIG_TV.get(), WFRegistry.prop()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<DisplayTile>> TILE_FRAME = WFRegistry.tile("frame", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)FrameTile::new), FRAME);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<DisplayTile>> TILE_PROJECTOR = WFRegistry.tile("projector", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)ProjectorTile::new), PROJECTOR);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<DisplayTile>> TILE_TV = WFRegistry.tile("tv", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)TvTile::new), TV);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<DisplayTile>> TILE_BIG_TV = WFRegistry.tile("big_tv", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)BigTvTile::new), BIG_TV);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> WATERTAB = TABS.register("tab", () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).icon(() -> new ItemStack((ItemLike)FRAME.get())).title((Component)Component.translatable((String)"itemGroup.waterframes")).build());

    private static DeferredHolder<BlockEntityType<?>, BlockEntityType<DisplayTile>> tile(String name, BlockEntityType.BlockEntitySupplier<DisplayTile> creator, Supplier<DisplayBlock> block) {
        return TILES.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)creator, (Block[])new Block[]{(Block)block.get()}).build(null));
    }

    private static Item.Properties prop() {
        return new Item.Properties().stacksTo(16).rarity(Rarity.EPIC);
    }

    public static void init(IEventBus bus, ModContainer container) {
        DATA.register(bus);
        BLOCKS.register(bus);
        ITEMS.register(bus);
        TILES.register(bus);
        TABS.register(bus);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        WaterFramesCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @EventBusSubscriber(modid="waterframes", bus=EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void onCreativeTabsLoading(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == WATERTAB.getKey()) {
                event.accept(REMOTE_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(FRAME_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(PROJECTOR_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(TV_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(BIG_TV_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }

        @SubscribeEvent
        public static void init(FMLCommonSetupEvent event) {
            DisplayNetwork.NET.registerType(DataSyncPacket.class, DataSyncPacket::new);
            DisplayNetwork.NET.registerType(PermLevelPacket.class, PermLevelPacket::new);
            DisplayNetwork.NET.registerType(ActivePacket.class, ActivePacket::new);
            DisplayNetwork.NET.registerType(LoopPacket.class, LoopPacket::new);
            DisplayNetwork.NET.registerType(MutePacket.class, MutePacket::new);
            DisplayNetwork.NET.registerType(PausePacket.class, PausePacket::new);
            DisplayNetwork.NET.registerType(TimePacket.class, TimePacket::new);
            DisplayNetwork.NET.registerType(VolumePacket.class, VolumePacket::new);
            DisplayNetwork.NET.registerType(VolumeRangePacket.class, VolumeRangePacket::new);
        }

        @SubscribeEvent
        public static void registerResourcePacks(AddPackFindersEvent e) {
            if (e.getPackType() == PackType.CLIENT_RESOURCES) {
                IModFile iModFile = ModList.get().getModFileById("waterframes").getFile();
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void registerTileRenderer(EntityRenderersEvent.RegisterRenderers e) {
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)TILE_FRAME.get()), DisplayRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)TILE_PROJECTOR.get()), DisplayRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)TILE_TV.get()), DisplayRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)TILE_BIG_TV.get()), DisplayRenderer::new);
        }
    }
}

