/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import me.srrapero720.waterframes.WaterFrames;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.ModConfigSpec;

public class WFConfig {
    private static final ModConfigSpec.Builder SERVER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.Builder CLIENT = new ModConfigSpec.Builder();
    private static final String[] WHITELIST = new String[]{"imgur.com", "gyazo.com", "prntscr.com", "tinypic.com", "puu.sh", "pinimg.com", "photobucket.com", "staticflickr.com", "flic.kr", "tenor.co", "gfycat.com", "giphy.com", "gph.is", "gifbin.com", "i.redd.it", "media.tumblr.com", "twimg.com", "discordapp.com", "images.discordapp.net", "discord.com", "githubusercontent.com", "googleusercontent.com", "googleapis.com", "wikimedia.org", "ytimg.com", "youtube.com", "youtu.be", "twitch.tv", "twitter.com", "soundcloud.com", "kick.com", "srrapero720.me", "fbcdn.net", "drive.google.com"};
    private static final ModConfigSpec.DoubleValue maxWidth;
    private static final ModConfigSpec.DoubleValue maxHeight;
    private static final ModConfigSpec.IntValue maxRenderDistance;
    private static final ModConfigSpec.DoubleValue maxProjectionDistance;
    private static final ModConfigSpec.IntValue maxVolumeDistance;
    private static final ModConfigSpec.IntValue maxVolume;
    private static final ModConfigSpec.BooleanValue useMultimedia;
    private static final ModConfigSpec.BooleanValue keepRendering;
    private static final ModConfigSpec.BooleanValue useLightsOnPlay;
    private static final ModConfigSpec.BooleanValue useRedstone;
    private static final ModConfigSpec.BooleanValue useMasterModeOnRedsone;
    private static final ModConfigSpec.IntValue remoteDistance;
    private static final ModConfigSpec.BooleanValue useInAdventure;
    private static final ModConfigSpec.BooleanValue useInSurvival;
    private static final ModConfigSpec.BooleanValue useForAnyone;
    private static final ModConfigSpec.BooleanValue useWhitelist;
    private static final ModConfigSpec.ConfigValue<List<String>> whitelist;
    private static final ModConfigSpec.BooleanValue overrideServerConfig;
    private static final ModConfigSpec.BooleanValue clientUseMultimedia;
    private static final ModConfigSpec.BooleanValue clientKeepsRendering;
    private static final ModConfigSpec.BooleanValue forceDevMode;
    private static final ModConfigSpec SERVER_SPEC;
    private static final ModConfigSpec CLIENT_SPEC;

    public static void init(IEventBus bus, ModContainer container) {
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        if (FMLLoader.getDist().isClient()) {
            container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        }
    }

    public static float maxWidth() {
        return (float)((Double)maxWidth.get()).doubleValue();
    }

    public static float maxHeight() {
        return (float)((Double)maxHeight.get()).doubleValue();
    }

    public static float maxWidth(float width) {
        return Math.min(width, WFConfig.maxWidth());
    }

    public static float maxHeight(float height) {
        return Math.min(height, WFConfig.maxHeight());
    }

    public static int maxRenDis() {
        return (Integer)maxRenderDistance.get();
    }

    public static int maxRenDis(int value) {
        return Math.min(value, WFConfig.maxRenDis());
    }

    public static float maxProjDis() {
        return (float)((Double)maxProjectionDistance.get()).doubleValue();
    }

    public static float maxProjDis(float value) {
        return Math.min(value, WFConfig.maxProjDis());
    }

    public static boolean keepsRendering() {
        return (Boolean)overrideServerConfig.get() != false ? (Boolean)clientKeepsRendering.get() : (Boolean)keepRendering.get();
    }

    public static boolean useLightOnPlay() {
        return (Boolean)useLightsOnPlay.get();
    }

    public static int maxVolDis() {
        return (Integer)maxVolumeDistance.get();
    }

    public static int maxVolDis(int value) {
        return Math.min(value, WFConfig.maxVolDis());
    }

    public static int maxVol() {
        return (Integer)maxVolume.get();
    }

    public static int maxVol(int value) {
        return Math.max(Math.min(value, WFConfig.maxVol()), 0);
    }

    public static boolean useMultimedia() {
        return (Boolean)overrideServerConfig.get() != false ? (Boolean)clientUseMultimedia.get() : (Boolean)useMultimedia.get();
    }

    public static boolean useRedstone() {
        return (Boolean)useRedstone.get();
    }

    public static boolean useMasterModeRedstone() {
        return WFConfig.useRedstone() && (Boolean)useMasterModeOnRedsone.get() != false;
    }

    public static int maxRcDis() {
        return (Integer)remoteDistance.get();
    }

    public static boolean useInAdv() {
        return (Boolean)useInAdventure.get();
    }

    public static boolean useInSurv() {
        return (Boolean)useInSurvival.get();
    }

    public static boolean useForAnyone() {
        return (Boolean)useForAnyone.get();
    }

    public static boolean useWhitelist() {
        return (Boolean)useWhitelist.get();
    }

    public static void useWhitelist(boolean state) {
        useWhitelist.set((Object)state);
        useWhitelist.save();
    }

    public static boolean toggleWhitelist() {
        WFConfig.useWhitelist(!WFConfig.useWhitelist());
        return WFConfig.useWhitelist();
    }

    public static void addOnWhitelist(String url) {
        List<String> w = WFConfig.mutableList(((List)whitelist.get()).iterator());
        w.add(url);
        whitelist.set(w);
        whitelist.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeOnWhitelist(String url) {
        List w = WFConfig.mutableList(((List)whitelist.get()).iterator());
        boolean removed = false;
        try {
            boolean bl = removed = w.remove(url);
            return bl;
        }
        finally {
            if (removed) {
                whitelist.set(w);
                whitelist.save();
            }
        }
    }

    public static boolean isWhiteListed(String url) {
        if (!WFConfig.useWhitelist()) {
            return true;
        }
        if (url.startsWith("local://") || url.startsWith("game://") || url.startsWith("user://") || url.startsWith("users://")) {
            return true;
        }
        try {
            String host = new URL(url).getHost();
            for (String s : (List)whitelist.get()) {
                if (!host.endsWith("." + s) && !host.equals(s)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static <T> List<T> mutableList(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public static boolean canSave(Player player, String url) {
        if (WFConfig.isAdmin(player)) {
            return true;
        }
        try {
            return url.isEmpty() || WFConfig.isWhiteListed(url);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canInteractBlock(Player player) {
        GameType gameType;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            v0 = serverPlayer.gameMode.getGameModeForPlayer();
        } else {
            v0 = gameType = Minecraft.getInstance().gameMode.getPlayerMode();
        }
        if (WFConfig.isAdmin(player)) {
            return true;
        }
        if (!WFConfig.useInSurv() && gameType.equals((Object)GameType.SURVIVAL)) {
            return false;
        }
        if (!WFConfig.useInAdv() && gameType.equals((Object)GameType.ADVENTURE)) {
            return false;
        }
        return WFConfig.useForAnyone();
    }

    public static boolean canInteractItem(Player player) {
        if (WFConfig.isAdmin(player)) {
            return true;
        }
        return WFConfig.useForAnyone();
    }

    public static boolean isAdmin(Player player) {
        Level level = player.level;
        String name = player.getGameProfile().getName();
        if (name.equals("SrRaapero720") || name.equals("SrRapero720")) {
            return true;
        }
        if (level.isClientSide()) {
            IntegratedServer integrated = Minecraft.getInstance().getSingleplayerServer();
            if (integrated != null) {
                return integrated.isSingleplayerOwner(player.getGameProfile()) || player.hasPermissions(integrated.getOperatorUserPermissionLevel());
            }
            return player.hasPermissions(WaterFrames.getServerOpPermissionLevel(level));
        }
        return player.hasPermissions(player.getServer().getOperatorUserPermissionLevel());
    }

    public static boolean isDevMode() {
        return !FMLLoader.isProduction() || (Boolean)forceDevMode.get() != false;
    }

    static {
        SERVER.comment("All configurations about rendering");
        SERVER.push("waterframes.rendering");
        maxWidth = SERVER.comment("Width limit of displays in blocks").defineInRange("maxWidth", 40.0, 1.0, 256.0);
        maxHeight = SERVER.comment("Height limit of displays in blocks").defineInRange("maxHeight", 40.0, 1.0, 256.0);
        maxRenderDistance = SERVER.comment("Max Radius of rendering distance in blocks").defineInRange("maxRenderDistance", 64, 4, 512);
        maxProjectionDistance = SERVER.comment("Max distance of projections in blocks").defineInRange("maxProjectionDistance", 64.0, 4.0, 512.0);
        keepRendering = SERVER.comment("Enables media processing and rendering, disabling it will not render nothing, you can still hear videos").define("keepRendering", true);
        SERVER.comment("Configuration related to multimedia sources like Videos or Music");
        SERVER.pop().push("multimedia");
        maxVolumeDistance = SERVER.comment("Max volume distance radius").defineInRange("maxVolumeDistance", 64, 8, 512);
        maxVolume = SERVER.comment(new String[]{"Max volume value", "values over 100 uses VLC \u00c3\u00bcberVolume"}).defineInRange("maxVolume", 100, 10, 120);
        SERVER.push("watermedia");
        useMultimedia = SERVER.comment("Enables VLC/FFMPEG usage for multimedia processing like videos and music (support added by WATERMeDIA)").define("enable", true);
        SERVER.comment("Configuration related to interactions with vanilla and modded features");
        SERVER.pop(2).push("block_behavior");
        useLightsOnPlay = SERVER.comment("Enable light feature on frames while is playing").define("lightOnPlay", true);
        SERVER.comment("Redstone interaction options");
        SERVER.push("redstone");
        useRedstone = SERVER.comment("Enable the feature").define("enable", true);
        useMasterModeOnRedsone = SERVER.comment("Redstone inputs forces paused playback and ignores any other control sources").define("masterMode", false);
        SERVER.pop();
        SERVER.comment("Configuration related to remote control");
        SERVER.pop().push("remote_control");
        remoteDistance = SERVER.comment("Distance in blocks of RC range").defineInRange("distance", 32, 4, 256);
        SERVER.comment("Configurations related to permissions");
        SERVER.pop().push("permissions");
        useInAdventure = SERVER.comment("Changes if players in Adventure mode can use displays").define("usableInAdventureMode", false);
        useInSurvival = SERVER.comment("Changes if players in Survival mode can use displays").define("usableInSurvivalMode", true);
        useForAnyone = SERVER.comment("Changes if any player can use displays, otherwise only admins can use it").define("usableForAnyone", true);
        SERVER.comment("Whitelist configuration: please stop bugging me with this :(");
        SERVER.push("whitelist");
        useWhitelist = SERVER.comment(new String[]{"Enables whitelist feature", "[WARNING]: THE AUTHOR OF THE MOD IS NOT RESPONSIBLE IF IN YOUR SERVER SOMEONE PUTS NSFW MEDIA", "WATERMEDIA HAVE SUPPORT FOR ADULT PAGES AND WHITELIST WAS DESIGNED TO PREVENT THAT"}).define("enable", true);
        whitelist = SERVER.define("urls", () -> Arrays.asList(WHITELIST), o -> false);
        SERVER.pop();
        SERVER.pop();
        CLIENT.push("waterframes");
        CLIENT.comment("Configurations to override server config");
        CLIENT.push("overrideConfig");
        overrideServerConfig = CLIENT.comment("Enables the option").define("enable", false);
        clientUseMultimedia = CLIENT.comment(new String[]{"Overrides 'waterframes.watermedia.enable' option", "Enables VLC/FFMPEG usage for multimedia processing (support added by WATERMeDIA)"}).define("useMultimedia", false);
        clientKeepsRendering = CLIENT.comment(new String[]{"overrides 'waterframes.rendering.keepRendering'", "Enables media processing and rendering, disabling it will not render nothing, you can still hear videos"}).define("keepRendering", false);
        forceDevMode = CLIENT.comment(new String[]{"WARNING: DO NOT CHANGE IT EXCEPT IF YOU KNOW WHAT ARE YOU DOING, TOGGLING IT ON MAY CAUSE CORRUPTIONS, UNEXPECTED BEHAVIORS OR WORLD DESTRUCTION", "forces WATERMeDIA and WATERFrAMES to run in developer mode", "This is was done for developers who has mods that causes compatibilities with waterframes (or watermedia)", "Let those modders test waterframes x incompatible mods (i see you stellarity owner)"}).define("forceDevMode", false);
        CLIENT.pop();
        CLIENT.pop();
        CLIENT_SPEC = CLIENT.build();
        SERVER_SPEC = SERVER.build();
    }
}

