/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.text.content.ContentItemStack;

public class TextBuilder {
    private static final NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
    private final List<Component> lines = new ArrayList<Component>();

    public TextBuilder() {
    }

    public TextBuilder add(List<Component> components) {
        for (Component component : components) {
            this.add(component);
        }
        return this;
    }

    public TextBuilder add(Component component) {
        if (this.lines.isEmpty()) {
            this.lines.add(component);
        } else {
            this.lines.get(this.lines.size() - 1).getSiblings().add(component);
        }
        return this;
    }

    public TextBuilder(String text) {
        this.text(text);
    }

    public TextBuilder translateIfCan(String text) {
        String translated = GuiControl.translate(text);
        if (!translated.equals(text)) {
            this.text(translated);
        }
        return this;
    }

    public TextBuilder translate(String text) {
        this.text(GuiControl.translate(text));
        return this;
    }

    public TextBuilder translate(String text, Object ... param) {
        this.text(GuiControl.translate(text, param));
        return this;
    }

    public TextBuilder text(String text) {
        if (text.contains("\n")) {
            String[] lines = text.split("\\n");
            this.add((Component)Component.literal((String)lines[0]));
            for (int i = 1; i < lines.length; ++i) {
                this.newLine();
                this.add((Component)Component.literal((String)lines[i]));
            }
            return this;
        }
        this.add((Component)Component.literal((String)text));
        return this;
    }

    public TextBuilder number(float number) {
        return this.number(number, false);
    }

    public TextBuilder number(float number, boolean rounded) {
        if (rounded) {
            this.text("" + Math.round(number));
        } else {
            this.text(format.format(number));
        }
        return this;
    }

    public TextBuilder number(double number) {
        return this.number(number, false);
    }

    public TextBuilder number(double number, boolean rounded) {
        if (rounded) {
            this.text("" + Math.round(number));
        } else {
            this.text(format.format(number));
        }
        return this;
    }

    public TextBuilder newLine() {
        this.lines.add((Component)Component.empty());
        return this;
    }

    public TextBuilder color(int color) {
        int r = ColorUtils.red(color);
        int g = ColorUtils.green(color);
        int b = ColorUtils.blue(color);
        int a = ColorUtils.alpha(color);
        this.text(String.valueOf(ChatFormatting.RED) + r + " " + String.valueOf(ChatFormatting.GREEN) + g + " " + String.valueOf(ChatFormatting.BLUE) + b + (String)(a < 255 ? " " + String.valueOf(ChatFormatting.WHITE) + a : ""));
        return this;
    }

    public TextBuilder stack(ItemStack stack) {
        this.add((Component)MutableComponent.create((ComponentContents)new ContentItemStack(stack)));
        return this;
    }

    public List<Component> build() {
        return this.lines;
    }
}

