/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.converation.ConfigTypePermission;
import team.creative.creativecore.common.config.gui.GuiConfigControl;
import team.creative.creativecore.common.config.holder.ConfigHolderObject;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.key.ConfigKeyType;
import team.creative.creativecore.common.config.premade.Permission;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.parent.GuiColumn;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.parent.GuiRow;
import team.creative.creativecore.common.gui.controls.parent.GuiTableScrollable;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.util.text.TextBuilder;

public class PermissionGuiLayer
extends GuiLayer {
    public ConfigTypePermission.GuiPermissionConfigButton button;
    protected boolean force;
    protected GuiTableScrollable table;
    protected ConfigTypeConveration converation;
    private List<PermissionGuiGroup> groups;
    private final HashMap<ConfigKeyType, GuiRow> rows = new HashMap();

    public PermissionGuiLayer() {
        super("permission", 500, 260);
    }

    @Override
    public void create() {
        if (this.button == null) {
            return;
        }
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.STRETCH;
        this.converation = this.button.key.converation();
        this.groups = new ArrayList<PermissionGuiGroup>();
        GuiParent top = new GuiParent();
        this.add((GuiControl)top);
        top.add((GuiControl)new GuiButton("add", x -> {
            PermissionGuiGroup group;
            if (this.converation != null) {
                GuiRow row = this.table.contentRows().iterator().next();
                group = new PermissionGuiGroupSimple("", null);
                this.groups.add(group);
                GuiColumn col = new GuiColumn();
                group.control = col;
                this.converation.createControls(col, this.button.configParent, this.button.key, this.button.side);
                row.addColumn(col);
            } else {
                Object newValue = ConfigTypeConveration.createObject(this.button.key.field());
                ConfigHolderObject holder = ConfigHolderObject.createUnrelated(this.button.side, newValue, newValue);
                group = new PermissionGuiGroupMulti(this.provider(), "", holder);
                this.groups.add(group);
                for (Map.Entry<ConfigKeyType, GuiRow> entry : this.rows.entrySet()) {
                    GuiColumn col = new GuiColumn();
                    GuiConfigControl config = new GuiConfigControl(this, entry.getKey(), this.button.side, 100, false){

                        @Override
                        public void changed() {
                            group.updateResetButton();
                        }
                    };
                    col.add((GuiControl)config);
                    ((PermissionGuiGroupMulti)group).controls.add(config);
                    config.init(null);
                    entry.getValue().addColumn(col);
                }
            }
            this.addGroupHeader(false, group, "");
            this.reflow();
        }).setTranslate("gui.perm.add"));
        this.table = new GuiTableScrollable();
        this.add((GuiControl)this.table);
        GuiRow topRow = this.table.getTopRow();
        topRow.addColumn(new GuiColumn());
        if (this.converation != null) {
            GuiRow row = new GuiRow();
            String caption = PermissionGuiLayer.translateOrDefault("gui.content", "content");
            GuiColumn guiColumn = new GuiColumn();
            guiColumn.setVAlign(VAlign.CENTER).add((GuiControl)new GuiLabel("label").setTitle((Component)Component.literal((String)((String)caption + ":"))));
            row.addColumn(guiColumn);
            this.table.addRow(row);
            for (Map.Entry entry : this.button.value.entrySet()) {
                Object defaultValue = this.button.defaultValue.getDirect(entry.getKey());
                group = new PermissionGuiGroupSimple(entry.getKey(), defaultValue);
                this.groups.add(group);
                GuiColumn col = new GuiColumn();
                ((PermissionGuiGroupSimple)group).control = col;
                this.converation.createControls(col, this.button.configParent, this.button.key, this.button.side);
                this.converation.loadValue(entry.getValue(), defaultValue, col, this.button.configParent, this.button.key, this.button.side);
                row.addColumn(col);
            }
        } else {
            ArrayList<GuiRow> rows = new ArrayList<GuiRow>();
            for (Map.Entry entry : this.button.value.entrySet()) {
                this.button.key.forceValue(entry.getValue(), this.button.side);
                Object copiedEntry = this.button.key.copy(this.provider(), this.button.side);
                Object defaultReference = this.button.defaultValue.getDirect(entry.getKey());
                if (defaultReference == null) {
                    defaultReference = copiedEntry;
                }
                ConfigHolderObject holder = ConfigHolderObject.createUnrelated(this.button.side, copiedEntry, defaultReference);
                group = new PermissionGuiGroupMulti(this.provider(), (String)entry.getKey(), holder);
                this.groups.add(group);
                int i = 0;
                for (ConfigKey key : holder.fields()) {
                    if (key.requiresRestart || key.isFolder()) continue;
                    if (rows.size() <= i) {
                        GuiRow row = new GuiRow();
                        String path = "config." + String.join((CharSequence)".", holder.path());
                        if (!path.endsWith(".")) {
                            path = path + ".";
                        }
                        String caption = PermissionGuiLayer.translateOrDefault(path + key.name + ".name", key.name);
                        String comment = path + key.name + ".comment";
                        GuiColumn col = new GuiColumn();
                        col.setVAlign(VAlign.CENTER).add(new GuiLabel("label" + i).setTitle((Component)Component.literal((String)(caption + ":"))).setTooltip(new TextBuilder().translateIfCan(comment).build()));
                        row.addColumn(col);
                        this.table.addRow(row);
                        rows.add(row);
                        this.rows.put((ConfigKeyType)key, row);
                    }
                    GuiColumn col = new GuiColumn();
                    GuiConfigControl config = new GuiConfigControl(this, (ConfigKeyType)key, Side.SERVER, 100, false, (PermissionGuiGroupMulti)group){
                        final /* synthetic */ PermissionGuiGroupMulti val$group;
                        {
                            this.val$group = permissionGuiGroupMulti;
                            super(field, side, width, showReset);
                        }

                        @Override
                        public void changed() {
                            this.val$group.updateResetButton();
                        }
                    };
                    col.add((GuiControl)config);
                    group.controls.add(config);
                    config.init(null);
                    ((GuiRow)rows.get(i)).addColumn(col);
                    ++i;
                }
            }
        }
        int i = 0;
        boolean defaultCol = true;
        for (String name : this.button.value.keySet()) {
            this.addGroupHeader(defaultCol, this.groups.get(i), name);
            defaultCol = false;
            ++i;
        }
        GuiLeftRightBox guiLeftRightBox = new GuiLeftRightBox();
        this.add(guiLeftRightBox.setUnexpandableX());
        guiLeftRightBox.addLeft(new GuiButton("cancel", x -> this.closeTopLayer()).setTranslate("gui.cancel"));
        guiLeftRightBox.addRight(new GuiButton("save", x -> {
            this.button.setNewValue(this.save());
            this.force = true;
            this.closeTopLayer();
        }).setTranslate("gui.save"));
        for (PermissionGuiGroup group : this.groups) {
            group.updateResetButton();
        }
    }

    protected void addGroupHeader(boolean defaultCol, PermissionGuiGroup group, String name) {
        GuiColumn col = new GuiColumn();
        col.setVAlign(VAlign.CENTER).setDim(new GuiSizeRule.GuiSizeRules().maxWidth(100));
        if (defaultCol) {
            col.add((GuiControl)new GuiLabel("name").setTitle((Component)Component.literal((String)name)));
        } else {
            group.textfield = new GuiTextfield("name", name).setDim(100);
            col.add((GuiControl)group.textfield);
        }
        if (!name.isEmpty() && this.button.defaultValue.containsKey(name)) {
            group.resetButton = (GuiButton)new GuiButton("r", x -> group.reset()).setTranslate("gui.reset").setAlign(Align.CENTER);
            col.add((GuiControl)group.resetButton);
        }
        if (!defaultCol) {
            col.add((GuiControl)new GuiButton("x", x -> {
                int index = this.groups.indexOf(group);
                this.groups.remove(index);
                this.table.removeContentCol(index);
                this.reflow();
            }).setTranslate("gui.del").setAlign(Align.CENTER));
        }
        this.table.getTopRow().addColumn(col);
    }

    @Override
    public void closeTopLayer() {
        Permission newValue = this.save();
        if (this.force || this.button.configTypePerm.areEqual(this.button.value, newValue, this.button.key, this.button.side)) {
            super.closeTopLayer();
        } else {
            GuiDialogHandler.openDialog(this.getIntegratedParent(), "savechanges", (x, y) -> {
                if (y == DialogGuiLayer.DialogButton.YES) {
                    this.button.setNewValue(newValue);
                } else if (y != DialogGuiLayer.DialogButton.CANCEL) {
                    this.force = true;
                    this.closeTopLayer();
                }
            }, DialogGuiLayer.DialogButton.YES, DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.CANCEL);
        }
    }

    public Permission save() {
        Permission<Object> perm = new Permission<Object>(this.groups.get(0).save());
        for (int i = 1; i < this.groups.size(); ++i) {
            perm.add(this.groups.get(i).getTitle(), this.groups.get(i).save());
        }
        return perm;
    }

    public class PermissionGuiGroupSimple
    extends PermissionGuiGroup {
        public GuiParent control;
        public final Object defaultValue;

        public PermissionGuiGroupSimple(String group, Object defaultValue) {
            super(group);
            this.defaultValue = defaultValue;
        }

        @Override
        protected void resetInternal() {
            PermissionGuiLayer.this.converation.loadValue(this.defaultValue, this.defaultValue, this.control, PermissionGuiLayer.this.button.configParent, null, PermissionGuiLayer.this.button.side);
        }

        @Override
        public boolean isDefault() {
            if (this.defaultValue == null) {
                return false;
            }
            return PermissionGuiLayer.this.converation.areEqual(this.defaultValue, this.save(), null, PermissionGuiLayer.this.button.side);
        }

        @Override
        public Object save() {
            return PermissionGuiLayer.this.converation.save(this.control, PermissionGuiLayer.this.button.configParent, PermissionGuiLayer.this.button.key, PermissionGuiLayer.this.button.side);
        }
    }

    public static class PermissionGuiGroupMulti
    extends PermissionGuiGroup {
        public final HolderLookup.Provider provider;
        public final ConfigHolderObject holder;
        public final List<GuiConfigControl> controls = new ArrayList<GuiConfigControl>();
        public GuiTextfield textfield;

        public PermissionGuiGroupMulti(HolderLookup.Provider provider, String group, ConfigHolderObject holder) {
            super(group);
            this.provider = provider;
            this.holder = holder;
        }

        @Override
        public Object save() {
            JsonObject json = new JsonObject();
            for (GuiConfigControl control : this.controls) {
                JsonElement element = control.save();
                if (element == null) continue;
                json.add(control.field.name, element);
            }
            this.holder.load(this.provider, false, true, json, Side.SERVER);
            return this.holder.object;
        }

        @Override
        protected void resetInternal() {
            for (GuiConfigControl control : this.controls) {
                control.reset();
            }
        }

        @Override
        public boolean isDefault() {
            this.save();
            return this.holder.isDefault(Side.SERVER);
        }
    }

    public static abstract class PermissionGuiGroup {
        public final String originalGroup;
        public GuiTextfield textfield;
        public GuiButton resetButton;

        public PermissionGuiGroup(String group) {
            this.originalGroup = group;
        }

        public String getTitle() {
            if (this.isDefaultGroup()) {
                return "default";
            }
            return this.textfield.getText();
        }

        public void updateResetButton() {
            if (this.resetButton != null) {
                this.resetButton.enabled = !this.isDefault();
            }
        }

        public abstract Object save();

        public void reset() {
            if (!this.isDefaultGroup()) {
                this.textfield.setText(this.originalGroup);
            }
            this.resetInternal();
            this.updateResetButton();
        }

        protected abstract void resetInternal();

        public abstract boolean isDefault();

        public boolean isDefaultGroup() {
            return this.textfield == null;
        }
    }
}

