/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation.registry;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.util.registry.FilteredHandlerRegistry;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.map.HashMapList;

@OnlyIn(value=Dist.CLIENT)
@Environment(value=EnvType.CLIENT)
public abstract class GuiRegistryTagHandler {
    public static final FilteredHandlerRegistry<Registry, GuiRegistryTagHandler> REGISTRY = new FilteredHandlerRegistry(new GuiRegistryTagHandler(){

        @Override
        public void createControls(GuiParent parent, Registry registry) {
            parent.add((GuiControl)new GuiComboBoxMapped<ResourceLocation>("elements", new TextMapBuilder<ResourceLocation>().addComponent(registry.getTagNames().iterator(), x -> {
                if (x.getNamespace().equals("minecraft")) {
                    return Component.literal((String)x.getPath());
                }
                return Component.literal((String)x.toString());
            })));
        }

        @Override
        public void loadValue(GuiParent parent, Registry registry, TagKey tag) {
            GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("elements");
            box.select(tag.location());
        }

        @Override
        public TagKey saveValue(GuiParent parent, Registry registry) {
            GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("elements");
            return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)((ResourceLocation)box.getSelected()));
        }
    });

    public abstract void createControls(GuiParent var1, Registry var2);

    public abstract void loadValue(GuiParent var1, Registry var2, TagKey var3);

    public abstract TagKey saveValue(GuiParent var1, Registry var2);

    static {
        REGISTRY.register((Registry)BuiltInRegistries.BLOCK, new GuiRegistryTagHandler(){
            private static final RandomSource RANDOM = RandomSource.create();

            @Override
            public void createControls(GuiParent parent, final Registry registry) {
                parent.add((GuiControl)new GuiStackSelector("content", null, new GuiStackSelector.StackCollector(this, new GuiStackSelector.GuiBlockSelector()){

                    @Override
                    public HashMapList<String, ItemStack> collect(Player player) {
                        HashMapList<String, ItemStack> map = new HashMapList<String, ItemStack>();
                        Iterator iterator = registry.getTags().iterator();
                        while (iterator.hasNext()) {
                            Pair pair = (Pair)iterator.next();
                            Optional o = ((HolderSet.Named)pair.getSecond()).getRandomElement(RANDOM);
                            if (o.isEmpty()) continue;
                            ItemStack stack = new ItemStack((ItemLike)((Holder)o.get()).value());
                            if (stack.isEmpty()) {
                                stack = new ItemStack((ItemLike)Blocks.BARRIER);
                            }
                            stack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)((TagKey)pair.getFirst()).location().toString()));
                            map.add("tags", stack);
                        }
                        return map;
                    }
                }));
            }

            private String getName(ItemStack stack) {
                MutableComponent comp = (MutableComponent)stack.get(DataComponents.ITEM_NAME);
                return ((PlainTextContents.LiteralContents)comp.getContents()).text();
            }

            @Override
            public void loadValue(GuiParent parent, Registry registry, TagKey tag) {
                GuiStackSelector selector = (GuiStackSelector)parent.get("content");
                String text = tag.location().toString();
                for (ArrayList<ItemStack> stacks : selector.getStacks().values()) {
                    for (ItemStack stack : stacks) {
                        if (!this.getName(stack).equals(text)) continue;
                        selector.setSelectedForce(stack);
                        return;
                    }
                }
                Optional o = registry.getRandomElementOf(tag, RANDOM);
                if (o.isEmpty()) {
                    return;
                }
                ItemStack stack = new ItemStack((ItemLike)((Holder)o.get()).value());
                stack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)tag.location().toString()));
                selector.setSelectedForce(stack);
            }

            @Override
            public TagKey saveValue(GuiParent parent, Registry registry) {
                GuiStackSelector selector = (GuiStackSelector)parent.get("content");
                return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)ResourceLocation.parse((String)this.getName(selector.getSelected())));
            }
        });
    }
}

