/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.converation.registry.GuiRegistryObjectHandler;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.premade.registry.RegistryObjectListConfig;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiListBoxBase;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.flow.GuiFlow;

public class ConfigTypeRegistryObjectList
extends ConfigTypeConveration<RegistryObjectListConfig> {
    @Override
    public RegistryObjectListConfig readElement(HolderLookup.Provider provider, RegistryObjectListConfig defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
        if (element.isJsonArray()) {
            RegistryObjectListConfig list = new RegistryObjectListConfig(defaultValue.registry);
            JsonArray array = element.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                list.add(ResourceLocation.parse((String)array.get(i).getAsString()));
            }
            return list;
        }
        return defaultValue;
    }

    @Override
    public JsonElement writeElement(HolderLookup.Provider provider, RegistryObjectListConfig value, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey key) {
        JsonArray array = new JsonArray(value.size());
        for (ResourceLocation location : value.locations()) {
            array.add(location.toString());
        }
        return array;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        parent.flow = GuiFlow.STACK_Y;
        GuiListBoxBase listBox = new GuiListBoxBase("data", true, new ArrayList());
        parent.add((GuiControl)listBox.setDim(50, 130).setExpandable());
        listBox.spacing = -1;
        parent.add((GuiControl)new GuiButton("add", null).setTitle((Component)Component.translatable((String)"gui.add")));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public void loadValue(RegistryObjectListConfig value, RegistryObjectListConfig defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        GuiListBoxBase listBox = (GuiListBoxBase)parent.get("data");
        if (!listBox.isEmpty()) {
            listBox.clearItems();
        }
        configParent.setCustomData(value.registry);
        GuiButton add = (GuiButton)parent.get("add");
        add.setPressed(x -> {
            GuiParent entry = new GuiParent().setAlign(Align.STRETCH);
            GuiRegistryObjectHandler.REGISTRY.get(value.registry).createControls(entry, value.registry);
            listBox.addItem(entry.setExpandableX());
        });
        for (ResourceLocation location : value.locations()) {
            GuiParent entry = new GuiParent().setAlign(Align.STRETCH);
            GuiRegistryObjectHandler.REGISTRY.get(value.registry).createControls(entry, value.registry);
            GuiRegistryObjectHandler.REGISTRY.get(value.registry).loadValue(entry, value.registry, location);
            listBox.addItem(entry.setExpandableX());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    protected RegistryObjectListConfig saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        RegistryObjectListConfig list = new RegistryObjectListConfig((Registry)configParent.getCustomData());
        GuiListBoxBase listBox = (GuiListBoxBase)parent.get("data");
        for (int i = 0; i < listBox.size(); ++i) {
            list.add(GuiRegistryObjectHandler.REGISTRY.get(list.registry).saveValue((GuiParent)listBox.get(i), list.registry));
        }
        return list;
    }

    @Override
    public RegistryObjectListConfig set(ConfigKey key, RegistryObjectListConfig value) {
        return value;
    }

    @Override
    public boolean areEqual(RegistryObjectListConfig one, RegistryObjectListConfig two, ConfigKey key, Side side) {
        if (one.size() != two.size()) {
            return false;
        }
        if (one.registry != two.registry) {
            return false;
        }
        ArrayList<ResourceLocation> copy = new ArrayList<ResourceLocation>();
        for (ResourceLocation location : two.locations()) {
            copy.add(location);
        }
        for (int i = 0; i < one.size(); ++i) {
            if (copy.remove(one.getLocation(i))) continue;
            return false;
        }
        return copy.isEmpty();
    }
}

