/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.methods;

import java.util.regex.Pattern;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class PlayerMethods {
    public static boolean hasEnchantedMainHand(Player player) {
        if (!player.hasItemInSlot(EquipmentSlot.MAINHAND)) {
            return false;
        }
        ItemStack stack = player.getMainHandItem();
        return EnchantmentHelper.hasAnyEnchantments((ItemStack)stack);
    }

    public static boolean hasEnchantedOffhand(Player player) {
        if (!player.hasItemInSlot(EquipmentSlot.OFFHAND)) {
            return false;
        }
        ItemStack stack = player.getOffhandItem();
        return EnchantmentHelper.hasAnyEnchantments((ItemStack)stack);
    }

    public static boolean hasDevelopmentName(Player player) {
        String name = player.getScoreboardName();
        return Pattern.matches("Dev", name) & name.length() == 3 | Pattern.matches("Player[0-9]{3}", name);
    }
}

