/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import it.hurts.sskirillss.relics.client.particles.BasicColoredParticle;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ParticleUtils {
    public static ParticleOptions constructSimpleSpark(Color color, float diameter, int lifetime, float scaleModifier) {
        return new BasicColoredParticle.Options(BasicColoredParticle.Constructor.builder().color(color.getRGB()).diameter(diameter).lifetime(lifetime).scaleModifier(scaleModifier).physical(true).roll(0.5f).build());
    }

    public static void createBall(ParticleOptions particle, Vec3 vec, Level world, int size, float speed) {
        if (!world.isClientSide()) {
            return;
        }
        for (int i = -size; i <= size; ++i) {
            for (int j = -size; j <= size; ++j) {
                for (int k = -size; k <= size; ++k) {
                    double d3 = (double)j + (world.random.nextDouble() - world.random.nextDouble()) * 0.5;
                    double d4 = (double)i + (world.random.nextDouble() - world.random.nextDouble()) * 0.5;
                    double d5 = (double)k + (world.random.nextDouble() - world.random.nextDouble()) * 0.5;
                    double d6 = (double)Mth.sqrt((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / (double)speed + world.random.nextGaussian() * 0.05;
                    world.addParticle(particle, vec.x(), vec.y(), vec.z(), d3 / d6, d4 / d6, d5 / d6);
                    if (i == -size || i == size || j == -size || j == size) continue;
                    k += size * 2 - 1;
                }
            }
        }
    }

    public static void createCyl(ParticleOptions particle, Vec3 center, Level level, double radius, float step) {
        int offset = 16;
        double len = (float)(Math.PI * 2 * radius);
        int num = (int)(len / (double)step);
        for (int i = 0; i < num; ++i) {
            int tries;
            double angle = Math.toRadians((double)(360.0f / (float)num * (float)i) + 360.0 * ((len / (double)step - (double)num) / (double)num / len));
            double extraX = radius * Math.sin(angle) + center.x();
            double extraZ = radius * Math.cos(angle) + center.z();
            double extraY = center.y();
            boolean foundPos = false;
            for (tries = 0; tries < offset * 2; ++tries) {
                Vec3 vec = new Vec3(extraX, extraY, extraZ);
                BlockPos pos = new BlockPos(Mth.floor((double)extraX), Mth.floor((double)extraY), Mth.floor((double)extraZ));
                BlockState state = level.getBlockState(pos);
                VoxelShape shape = state.getCollisionShape((BlockGetter)level, pos);
                if (state.getBlock() instanceof LiquidBlock) {
                    shape = Shapes.block();
                }
                if (shape.isEmpty()) {
                    if (!foundPos) {
                        extraY -= 1.0;
                        continue;
                    }
                } else {
                    foundPos = true;
                }
                if (shape.isEmpty()) break;
                AABB aabb = shape.bounds();
                if (!aabb.move(pos).contains(vec)) {
                    if (!(aabb.maxY >= 1.0)) break;
                    extraY += 1.0;
                    continue;
                }
                extraY += (double)step;
            }
            if (tries >= offset * 2) continue;
            level.addParticle(particle, extraX, extraY + (double)0.1f, extraZ, 0.0, 0.0, 0.0);
        }
    }

    public static void createLine(ParticleOptions particle, Level level, Vec3 start, Vec3 end, int amount, Vec3 motion) {
        Vec3 delta = end.subtract(start);
        Vec3 dir = delta.normalize();
        for (int i = 0; i < amount; ++i) {
            double progress = (double)i * delta.length() / (double)amount;
            level.addParticle(particle, start.x + dir.x * progress, start.y + dir.y * progress, start.z + dir.z * progress, motion.x, motion.y, motion.z);
        }
    }

    public static void createLine(ParticleOptions particle, Level level, Vec3 start, Vec3 end, int amount) {
        ParticleUtils.createLine(particle, level, start, end, amount, Vec3.ZERO);
    }
}

